document.addEventListener("DOMContentLoaded", function() {
    /*
    The event listener is applied to all words in both tables.
     */
    let practice_table = document.getElementsByClassName("practice-td");
    let word_table = document.getElementsByClassName("word-td");
    let source_language = document.getElementById("id_source_language");
    let target_language = document.getElementById("id_target_language");
    let domain = document.getElementById("id_domain");
    let dialect = document.getElementById("id_dialect");
    source_language.addEventListener('change', flip_domain, false);
    target_language.addEventListener('change', submit_dropdown, false);
    domain.addEventListener('change', submit_dropdown, false);
    dialect.addEventListener('change', submit_dropdown, false);
    for (let row=0; row < word_table.length; row++) {
        word_table[row].addEventListener('click', practice, false);
    }
    for (let row=0; row < practice_table.length; row++) {
        practice_table[row].addEventListener('click', remove_practice, false);
    }
    flip_domain(false);
});

function practice()
{
    /*
    copy the selected word to the practice table, if it is not already present in
     the practice table. adjust the callback accordingly.
     */
    const row_to_copy = this.parentElement;
    const target_table_body = document.getElementById("practice-body");
    let hidden_input = document.getElementById('practice_list');
    var num = row_to_copy.getAttribute('data-id');
    let avoid = false; // avoid adding the same word to the table twice
    for (var r=0; r<target_table_body.rows.length; r++) {
        att = target_table_body.rows[r].getAttribute('data-id');
        if(att===num) { // word is already present in practice table
            avoid = true;
            alert("word "+row_to_copy.firstElementChild.firstElementChild.innerHTML+
                " ("+num+") already in" + " practice table");
            break;
        }
    }
    if(!avoid) {
        const cloned = row_to_copy.cloneNode(true);
        target_table_body.appendChild(cloned);
        // reassign the right event handler to practice word
        target_table_body.lastElementChild.children[0].addEventListener('click', remove_practice);
        // append practice word to form so that server can rebuild the practice table
        if (hidden_input.value)
            hidden_input.value = hidden_input.value + ',' + num;
        else
            hidden_input.value = num;
    }
    submit_dropdown();
}

function remove_practice()
{
    const row = this.parentElement;
    let hidden_input = document.getElementById('practice_list');
    const num = row.getAttribute('data-id');
    row.remove();
    if (hidden_input.value)
        hidden_input.value = hidden_input.value + ',-' + num;
    else
        hidden_input.value = '-' + num;
}

function flip_domain(real_change=true)
// flip the domain dropdown according to the selected language.
// flip the pronunciation dropdown according to the selected language.
{
    let domain = document.getElementById("id_domain");
    let dialect = document.getElementById("id_dialect");
    let source_language = document.getElementById("id_source_language");
    let target_language = document.getElementById("id_target_language");
    let english_domain = [1, 3];
    let dutch_domain = [2, 4];
    let english_dialect = english_domain;
    let dutch_dialect = [2, 5];
    let german_dialect = [4];
    const max_domain = 5;
    const max_dialect = 6;
    const max_language = 4;

    // language changed, reset all select tags
    if(real_change) {
        // only apply if not called from page reload
        target_language.options[0].selected = 'selected';
        domain.options[0].selected = 'selected';
        dialect.options[0].selected = 'selected';
    }

    // specifically disable and hide all none relevant options per language
    switch (source_language.value) {
        case "1":  // english
        {
            domain.disabled = false;
            dialect.disabled = false;
            for (let i=1; i<max_language; i++) {
                target_language.options[i].hidden = target_language.options[i].disabled = i === 1;
            }
            for (let i=1; i<max_domain; i++) {
                domain.options[i].disabled = domain.options[i].hidden = !english_domain.includes(i);
            }
            for (let i=1; i<max_dialect; i++) {
                dialect.options[i].disabled = dialect.options[i].hidden = !english_dialect.includes(i);
            }
            break;
        }
        case "2":  // dutch
        {
            domain.disabled = false;
            dialect.disabled = false;
            for (let i=1; i<max_language; i++) {
                target_language.options[i].hidden = target_language.options[i].disabled = i === 2;
            }
            for (let i=1; i<max_domain; i++) {
                domain.options[i].disabled = domain.options[i].hidden = !dutch_domain.includes(i);
            }
            for (let i=1; i<max_dialect; i++) {
                dialect.options[i].disabled = dialect.options[i].hidden = !dutch_dialect.includes(i);
            }
            break;
        }
        case "3": // german
        {
            domain.disabled = true;
            dialect.disabled = false;
            for (let i=1; i<max_language; i++) {
                target_language.options[i].hidden = target_language.options[i].disabled = i === 3;
            }
            for (let i=1; i<max_dialect; i++) {
                dialect.options[i].disabled = dialect.options[i].hidden = !german_dialect.includes(i);
            }
            break;
        }
        case "4": // chinese
        {
            domain.disabled = true;
            dialect.disabled = true;
            for (let i=1; i<max_language; i++) {
                target_language.options[i].hidden = target_language.options[i].disabled = i === 4;
            }
            break;
        }
        default:
        {
            for (let i=1; i<max_language; i++) {
                target_language.options[i].hidden = target_language.options[i].disabled = false;
            }
            domain.disabled = true;
            dialect.disabled = true;
            break;
        }
    }
    if (real_change)
        submit_dropdown();
}

function submit_dropdown()
{
    let form = document.getElementById("submit-id-subbutt");
    form.parentElement.parentElement.submit();
}