import json
from logging import getLogger, DEBUG
from django.utils.timezone import now
from django import setup
from os import environ

environ.setdefault("DJANGO_SETTINGS_MODULE", "eloquent.settings")
setup()


from elo.models import Mp3


class PopulateMP3:
    def __init__(self, filename: str):
        with open(filename) as f:
            self.inp = json.load(f)
            self.logger = getLogger('eloquent')
            self.logger.setLevel(DEBUG)

    def populate(self):
        self.logger.info(f'number of mp3 records: {len(self.inp)}')
        for n, x in enumerate(self.inp):
            mp3 = Mp3()
            mp3.id = int(x['ID'])
            mp3.name = x['NAME']
            mp3.mime_type = x['MIME_TYPE']
            mp3.doc_size = x['DOC_SIZE']
            mp3.dad_charset = x['DAD_CHARSET']
            mp3.content_type = x['CONTENT_TYPE']
            mp3.content = x['CONTENT']
            mp3.blob_content = bytes.fromhex(x['BLOB_CONTENT'][1:-1])
            mp3.addate = now()
            mp3.mtdate = mp3.addate
            mp3.mtanr = x['MTANR']
            mp3.save()
            if n % 100 == 0:
                self.logger.info(f"written {n} records")

if __name__ == '__main__':
    p = PopulateMP3('config/MP3.json')
    p.populate()



