from django_filters import (FilterSet, CharFilter,)
from django.forms.widgets import TextInput
from elo import logger
from elo.models import Word


class WordFilter(FilterSet):

    source_text__icontains = CharFilter(label="", field_name="source_text",
                             widget=TextInput(attrs={'placeholder': 'Search source text'}),
                             lookup_expr='icontains')

    def __init__(self, data=None, *args, **kwargs):
        # this is to force the initial values of the filter to dutch, english, nederlands
        # TODO: this will only work if the languages retain their ids
        if data is not None:
            data = data.copy()
            data.setdefault('source_language', 2)
            data.setdefault('target_language', 1)
            data.setdefault('dialect', 2)

        super().__init__(data, *args, **kwargs)

    class Meta:
        model = Word
        fields = {
            'source_language': ['exact'],
            'target_language': ['exact'],
            'dialect': ['exact'],
            'domain': ['exact'],
            'source_text': ['icontains']
        }
