from crispy_forms.helper import FormHelper
from crispy_forms.layout import (
    Layout, Submit, Fieldset, Row, Column, ButtonHolder,
    Div, Hidden)

from elo import logger


class WordFilterFormHelper(FormHelper):
    form_method = 'GET'
    fs1 = Fieldset(
        "",
        Row(
            Column('source_language'),
            Column('target_language'),
            Column('dialect'),
            Column('domain'),
        ),
        css_class="pt-2"
    )
    fs2 = Fieldset(
        "",
        Row(
            Column('source_text__icontains')
        ),
        Row(
            Hidden('practice_values', value='', id="practice_list")
        ),
        css_class="border p-2"
    )
    bh = ButtonHolder(
        Submit('subbutt', 'Apply Filter', hidden=True),
    )
    buttons_superuser = (
        Submit('addword', 'Add Word(s)',
            css_class="btn btn-tiu btn-sm btn-link"),
    )

    def __init__(self, *args, **kwargs):
        """
        We create a slightly different form for a superuser.
        :param args:
        :param kwargs: contains user, if user is logged in
        """
        user = kwargs.pop('user')  # super Form does not like extra kwargs
        subset = kwargs.pop('subset')  # the letter selection button
        super().__init__(*args, **kwargs)
        if not user.is_anonymous and not self.buttons_superuser[0] in self.bh:  # Ok, user is logged
            self.bh.extend(self.buttons_superuser)

        letters = list()
        for i in "ABCDEFGHIJKLMNOPQRSTUVWXYZ":
            if i.lower() == subset:
                style = "pt-2 pb-2 btn-sm letters"
            else:
                style = "mt-2 pt-2 mb-2 pb-2 btn-sm btn-tiu letters"
            letters.append(Submit(i.lower(), i, css_class=style))
        self.layout = Layout(
            self.fs1,
            ButtonHolder(
                Div(Div(*letters), css_class="btn-group")),
            self.fs2,
            self.bh
        )
