from crispy_forms.helper import FormHelper
from crispy_forms.layout import (
    Layout, Submit, Fieldset, Row, Column, ButtonHolder,
    Div, Hidden)


class WordFilterFormHelper(FormHelper):
    form_method = 'GET'
    fs1 = Fieldset(
        "",
        Row(
            Column('source_language'),
            Column('target_language'),
            Column('dialect'),
            Column('domain'),
        ),
        css_class="pt-2"
    )
    fs2 = Fieldset(
        "",
        Row(
            Column('source_text__icontains')
        ),
        Row(
            Hidden('practice_values', value='', id="practice_list")
        ),
        css_class="border p-2"
    )
    bh = ButtonHolder(
        Submit('subbutt', 'Apply Filter', hidden=True),
    )

    def __init__(self, *args, **kwargs):
        """
        We create a slightly different form for a superuser.
        :param args:
        :param kwargs: contains user, if user is logged in
        """
        subset = kwargs.pop('subset')  # the letter selection button
        super().__init__(*args, **kwargs)

        letters = list()
        for i in "ABCDEFGHIJKLMNOPQRSTUVWXYZ":
            if i.lower() == subset:
                style = "pt-2 pb-2 btn-sm letters"
            else:
                style = "mt-2 pt-2 mb-2 pb-2 btn-sm btn-tiu letters"
            letters.append(Submit(i.lower(), i, css_class=style))
        self.layout = Layout(
            self.bh,
            self.fs1,
            ButtonHolder(
                Div(Div(*letters), css_class="btn-group", id='letters')),
            self.fs2,
        )
