import json
from logging import getLogger, DEBUG

from django.db import IntegrityError
from django.utils.timezone import now
from django import setup
from os import environ
from pathlib import Path

environ.setdefault("DJANGO_SETTINGS_MODULE", "eloquent.settings")
setup()

from elo.models import EloquentUser


class PopUser:
    def __init__(self, p: Path):
        with open(p) as f:
            self.j = json.load(f)

    def populate(self):
        for u in self.j:
            eu = EloquentUser()
            eu.name = u['NAME']
            eu.username = u['NAME']
            eu.active = u['ACTIVE'].upper() == 'Y'
            eu.anr = u['ANR']
            eu.email = u['EMAIL']
            eu.attempt = u['TRY']
            eu.sortname = u['SORTNAME']
            eu.lastlogin = u['LASTLOGIN']
            eu.telno = u['TELNO']
            eu.role_id = u['ROLE_ID']
            try:
                eu.save()
            except (IntegrityError, Exception):
                if not eu.email:
                    eu.email = "unknown@tilburguniversity.edu"
                if EloquentUser.objects.filter(username=eu.username).exists():
                    eu.username = eu.username+'.'
                eu.save()


if __name__ == '__main__':
    p = PopUser(Path('config').parent / 'USER.json')
    p.populate()
