from pathlib import Path
from re import compile


def change_bad_django_names():
    """
    change the names of files appertaining to rule (3)
    so

    fancyword (adj).mp3

    would become

    fancyword_adj.mp3


    :return:
    """

    bad_pat = compile(r"(.*) \((.*)\)(.*)")
    p = Path('media/mp3')
    for f in p.glob('*.mp3'):
        m = bad_pat.search(f.name)
        if m:
            a, b, c = m.groups()
            print(f"{a}_{b}{c}")
            f.rename(f"media/mp3/{a}_{b}{c}")

if __name__ == "__main__":
    change_bad_django_names()