from django.contrib import admin

from elo.models import (
    Word, Language, Domain, Dialect, Mp3, Synonym, ExampleUsage,
    Translation, WordDialect)


class SynonymInline(admin.TabularInline):
    model = Synonym


class TranslationInline(admin.TabularInline):
    model = Translation


class ExampleUsageInline(admin.StackedInline):
    model = ExampleUsage


class WordAdmin(admin.ModelAdmin):
    search_fields = ['source_text']
    list_display = ['source_language', 'dialect', 'source_text', 'target_language',
                    'translated_text', 'mp3', 'domain']
    list_filter = ['source_language', 'dialect', 'target_language', 'domain']
    list_editable = ['dialect', 'source_text', 'mp3', 'translated_text', 'domain']
    ordering = ['source_language', 'source_text', 'target_language']

    inlines = [
        TranslationInline, SynonymInline, ExampleUsageInline
    ]


class LanguageAdmin(admin.ModelAdmin):
    pass


class SynonymAdmin(admin.ModelAdmin):
    pass


class ExampleUsageAdmin(admin.ModelAdmin):
    pass


class DomainAdmin(admin.ModelAdmin):
    pass


class DialectAdmin(admin.ModelAdmin):
    pass


class Mp3Admin(admin.ModelAdmin):
    search_fields = ["id"]
    list_display = ['id', 'name']
    ordering = ["id"]


class TranslationAdmin(admin.ModelAdmin):
    search_fields = ["word__id", "text", "word__source_text"]
    list_filter = ["word__source_language", "word__target_language"]
    list_display = ["word", "lang", "text"]
    list_editable = ["text"]
    ordering = ["word__source_text"]


class WordDialectAdmin(admin.ModelAdmin):
    ordering = ["dialect", "word__source_text"]
    list_filter = ["dialect", "word__source_language"]
    list_display = ["word", "dialect", "mp3"]
    search_fields = ["word__source_text"]


admin.site.register(Word, WordAdmin)
admin.site.register(Language, LanguageAdmin)
admin.site.register(Domain, DomainAdmin)
admin.site.register(Dialect, DialectAdmin)
admin.site.register(Mp3, Mp3Admin)
admin.site.register(Synonym, SynonymAdmin)
admin.site.register(ExampleUsage, ExampleUsageAdmin)
admin.site.register(Translation, TranslationAdmin)
admin.site.register(WordDialect, WordDialectAdmin)
