# Generated by Django 2.2.24 on 2021-10-14 09:16

import django.contrib.auth.models
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='Dialect',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('name', models.TextField(blank=True, db_column='NAME', null=True)),
                ('adddate', models.DateTimeField(blank=True, db_column='ADDDATE', null=True)),
                ('mtdate', models.DateTimeField(blank=True, db_column='MTDATE', null=True)),
                ('mtanr', models.TextField(blank=True, db_column='MTANR', null=True)),
            ],
            options={
                'db_table': 'ELOQUENT_DIALECT',
            },
        ),
        migrations.CreateModel(
            name='Domain',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('name', models.TextField(blank=True, db_column='NAME', null=True)),
                ('mtdate', models.DateTimeField(blank=True, db_column='MTDATE', null=True)),
                ('mtanr', models.TextField(blank=True, db_column='MTANR', null=True)),
                ('adddate', models.DateTimeField(blank=True, db_column='ADDDATE', null=True)),
            ],
            options={
                'db_table': 'ELOQUENT_DOMAIN',
            },
        ),
        migrations.CreateModel(
            name='Language',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('name', models.TextField(blank=True, db_column='NAME', null=True)),
                ('adddate', models.DateTimeField(blank=True, db_column='ADDDATE', null=True)),
                ('mtdate', models.DateTimeField(blank=True, db_column='MTDATE', null=True)),
                ('mtanr', models.TextField(blank=True, db_column='MTANR', null=True)),
                ('flag_url', models.TextField(blank=True, db_column='FLAG_URL', null=True)),
                ('comments', models.TextField(blank=True, db_column='COMMENTS', null=True)),
            ],
            options={
                'db_table': 'ELOQUENT_LANGUAGE',
            },
        ),
        migrations.CreateModel(
            name='Mp3',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('name', models.TextField(blank=True, db_column='NAME', null=True)),
                ('mime_type', models.TextField(blank=True, db_column='MIME_TYPE', null=True)),
                ('doc_size', models.TextField(blank=True, db_column='DOC_SIZE', null=True)),
                ('dad_charset', models.TextField(blank=True, db_column='DAD_CHARSET', null=True)),
                ('content_type', models.TextField(blank=True, db_column='CONTENT_TYPE', null=True)),
                ('content', models.TextField(blank=True, db_column='CONTENT', null=True)),
                ('blob_content',
                 models.BinaryField(blank=True, db_column='BLOB_CONTENT', null=True)),
                ('addate', models.DateTimeField(blank=True, db_column='ADDATE', null=True)),
                ('mtdate', models.DateTimeField(blank=True, db_column='MTDATE', null=True)),
                ('mtanr', models.TextField(blank=True, db_column='MTANR', null=True)),
            ],
            options={
                'db_table': 'ELOQUENT_MP3',
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('name', models.CharField(db_column='NAME', max_length=32)),
                ('adddate', models.DateTimeField(auto_now_add=True, db_column='ADDDATE')),
                ('mtdate', models.DateTimeField(blank=True, db_column='MTDATE', null=True)),
                ('mtanr', models.IntegerField(db_column='MTANR')),
            ],
            options={
                'db_table': 'ELOQUENT_ROLE',
            },
        ),
        migrations.CreateModel(
            name='Word',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('source_text', models.CharField(max_length=256)),
                ('translated_text', models.CharField(max_length=256)),
                ('mp3_number', models.IntegerField()),
                ('mp3', models.FileField(blank=True, null=True, upload_to='mp3')),
                ('adddate', models.DateTimeField(auto_now_add=True)),
                ('mtdate', models.DateTimeField(blank=True, null=True)),
                ('dialect',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='elo.Dialect',
                                   verbose_name='Pronunciation')),
                ('domain', models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE,
                                             to='elo.Domain')),
                ('source_language', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                      related_name='source_language',
                                                      to='elo.Language',
                                                      verbose_name='Source language')),
                ('target_language', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                      related_name='target_language',
                                                      to='elo.Language',
                                                      verbose_name='Translated language')),
            ],
            options={
                'db_table': 'ELOQUENT_WORD',
            },
        ),
        migrations.CreateModel(
            name='WordDialect',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('mp3', models.FileField(blank=True, null=True, upload_to='mp3')),
                ('dialect',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='elo.Dialect')),
                ('word',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='elo.Word')),
            ],
            options={
                'db_table': 'WORDDIALECT',
            },
        ),
        migrations.CreateModel(
            name='Translation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('text', models.CharField(blank=True, max_length=256, null=True)),
                ('lang', models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE,
                                           related_name='lang', to='elo.Language')),
                ('word', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                           related_name='translation_word', to='elo.Word')),
            ],
            options={
                'db_table': 'ELOQUENT_TRANSLATION',
            },
        ),
        migrations.CreateModel(
            name='Synonym',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('synonym', models.CharField(blank=True, max_length=256, null=True)),
                ('word', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                           related_name='synonym_word', to='elo.Word')),
            ],
            options={
                'db_table': 'ELOQUENT_SYNONYM',
            },
        ),
        migrations.CreateModel(
            name='Practice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('ip', models.CharField(max_length=20)),
                ('word',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='elo.Word')),
            ],
            options={
                'db_table': 'PRACTICE',
            },
        ),
        migrations.CreateModel(
            name='ExampleUsage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('example', models.CharField(blank=True, max_length=512, null=True)),
                ('word', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                           related_name='example_word', to='elo.Word')),
            ],
            options={
                'db_table': 'ELOQUENT_EXAMPLE',
            },
        ),
        migrations.CreateModel(
            name='EloquentUser',
            fields=[
                ('user_ptr',
                 models.OneToOneField(auto_created=True,
                                      on_delete=django.db.models.deletion.CASCADE,
                                      parent_link=True, primary_key=True, serialize=False,
                                      to=settings.AUTH_USER_MODEL)),
                ('anr', models.CharField(db_column='ANR', max_length=7)),
                ('active', models.BooleanField(db_column='ACTIVE')),
                ('name', models.CharField(db_column='NAME', max_length=64)),
                ('sortname', models.CharField(db_column='SORTNAME', max_length=64)),
                ('lastlogin', models.DateTimeField(blank=True, db_column='LASTLOGIN', null=True)),
                ('adddate', models.DateTimeField(auto_now_add=True, db_column='ADDDATE')),
                ('mtdate', models.DateTimeField(blank=True, db_column='MTDATE', null=True)),
                (
                    'telno',
                    models.CharField(blank=True, db_column='TELNO', max_length=64, null=True)),
                ('attempt', models.IntegerField(db_column='ATTEMPT', default=0, null=True)),
                ('role',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='elo.Role')),
            ],
            options={
                'db_table': 'ELOQUENT_USER',
            },
            bases=('auth.user',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.AddField(
            model_name='domain',
            name='language',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='elo.Language'),
        ),
        migrations.AddField(
            model_name='dialect',
            name='language',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='elo.Language'),
        ),
    ]
