from crispy_forms.helper import FormHelper
from crispy_forms.layout import (Layout, Submit, Fieldset, Row, Column, ButtonHolder,
                                 Div, Hidden)


class WordFilterFormHelper(FormHelper):
    form_method = 'GET'
    fs = Fieldset(
        "",
        Row(
            Column('source_text__icontains')
        ),
        Row(
            Column('source_language'),
            Column('target_language'),
            Column('dialect'),
            Column('domain'),
        ),
        Row(
            Hidden('practice_values', value='', id="practice_list")
        ),
        css_class="border p-2"
    )
    bh = ButtonHolder(
        Submit('submit', 'Apply Filter'),
        Submit('synonyms', 'Synonyms', css_class="btn btn-light btn-sm"),
        Submit('example', 'Example Sentences', css_class="btn btn-light btn-sm"),
        Submit('practice', 'Practice words', css_class="btn btn-light btn-sm"),
        css_class="border p-2"
    )
    buttons_superuser = (
        Submit('addword', 'Add Word(s)',
               css_class="btn btn-light btn-sm btn-link"),
    )

    def __init__(self, *args, **kwargs):
        """
        We create a slightly different form for a superuser.
        :param args:
        :param kwargs: contains user, if user is logged in
        """
        user = kwargs.pop('user')  # super Form does not like extra kwargs
        practice = kwargs.pop('practice')
        super().__init__(*args, **kwargs)
        if not user.is_anonymous and not self.buttons_superuser[0] in self.bh:  # Ok, user is logged
            self.bh.extend(self.buttons_superuser)
        if practice:
            self.bh[3].value = 'Reset practice table'
            self.bh[3].field_classes = "btn btn-warning btn-sm"
        else:
            self.bh[3].value = 'Practice words'
            self.bh[3].field_classes = "btn btn-light btn-sm"
        letters = [Submit(i.lower(), i, css_class="btn btn-dark btn-sm") for i in
                   'ABCDEFGHIJKLMNOPQRSTUVWXYZ']
        self.layout = Layout(
            ButtonHolder(
                Div(*letters, css_class="btn-group"), css_class="border p-2"),
            self.fs, self.bh
        )
