% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cache.R
\name{get_cache}
\alias{get_cache}
\title{Get a cached vector from a graph object}
\usage{
get_cache(graph, name = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{name}{the name of the object to
extract from the cache. If none supplied,
the most recent object added to the cache
will be returned.}
}
\value{
a vector.
}
\description{
Get the vector cached in a
graph object of class \code{dgr_graph}.
}
\examples{
# Set a seed
set.seed(23)

# Create a graph with 5 nodes and 5 edges
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 5) \%>\%
  set_node_attrs(
    node_attr = value,
    values = rnorm(
      n = count_nodes(.),
      mean = 8,
      sd = 2)) \%>\%
  add_edges_w_string(
    edges = "1->2 1->3 2->4 2->5 3->2")

# Cache all values from the node attribute `value`
# as a numeric vector
graph <-
  graph \%>\%
  set_cache(
    name = "value",
    to_cache = get_node_attrs(
      graph = .,
      node_attr = value))

# Return the cached vector
graph \%>\%
  get_cache()
}
