% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_edges.R
\name{get_edges}
\alias{get_edges}
\title{Get node IDs associated with edges}
\usage{
get_edges(graph, conditions = NULL, return_type = "vector",
  return_values = "id")
}
\arguments{
\item{graph}{a graph object of
class \code{dgr_graph}.}

\item{conditions}{an option to
use filtering conditions for the
retrieval of edges.}

\item{return_type}{using
\code{vector} (the default), a
vector of character objects
representing the edges is provided.
With \code{list} a list object will
be provided that contains vectors
of outgoing and incoming node IDs
associated with edges. With
\code{df}, a data frame containing
outgoing and incoming node IDs
associated with edges.}

\item{return_values}{using
\code{id} (the default) results in
node ID values returned in the edge
definitions. With \code{label}, the
node labels will instead be used to
define edges.}
}
\value{
a list, data frame, or a
vector object, depending on the
value given to \code{return_type}.
}
\description{
Obtain a vector,
data frame, or list of node IDs
associated with edges in a graph
object. An optional filter by edge
attribute can limit the set of
edges returned.
}
\examples{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    label = c("one", "two", "three", "four"),
    type = "letter",
    color = c("red", "green", "grey", "blue"),
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "leading_to",
    color = c("pink", "blue", "blue"),
    value = c(3.9, 2.5, 7.3))

# Create a graph
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Get all edges within a graph, returned as a list
graph \%>\%
  get_edges(
    return_type = "vector")

# Get all edges within a graph, returned as a
# data frame
graph \%>\%
  get_edges(
    return_type = "df")

# Get all edges returned as a list
graph \%>\%
  get_edges(
    return_type = "list")

# Get a vector of edges using
# a numeric comparison (i.e.,
# all edges with a `value`
# attribute greater than 3)
graph \%>\%
  get_edges(
    conditions = value > 3,
    return_type = "vector")

# Get a vector of edges using
# a matching condition
graph \%>\%
  get_edges(
    conditions = color == "pink",
    return_type = "vector")

# Use multiple conditions to
# return edges with the
# desired attribute values
graph \%>\%
  get_edges(
    conditions =
      color == "blue" &
      value > 3,
    return_type = "vector")

# Use `return_values = "label"`
# to return the labels of the
# connected nodes
graph \%>\%
  get_edges(
    conditions =
      color == "blue" &
      value > 3,
    return_type = "vector",
    return_values = "label")
}
