#! /usr/bin/env perl

# $Id: Build.PL 47485 2018-03-23 15:59:12Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/libuvt-vlan-perl/Build.PL $

use strict;
use warnings FATAL => 'all';

use Module::Build;
use File::Find;

do {
	# create the MANIFEST file on the fly
	open my $fh, '>', 'MANIFEST';
	find({wanted => sub { print $fh "$_\n" or die "write(MANIFEST): $!\n" if -f }, no_chdir => 1, follow => 0}, 'lib');
	close $fh or die "close(MANIFEST): $!\n";
};

my $build = new Module::Build(
	module_name => 'UvT::VLAN',
	dist_name => 'uvt-vlan',
	dist_version => '2.2',
	dist_abstract => 'Look up addresses in the UvT VLAN list',
	dist_author => 'Casper Gielen <cgielen@uvt.nl>',
	license => 'perl',
	create_makefile_pl => 'small',
	script_files => [],
);

$build->create_build_script;
