/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.codehaus.groovy.tools.LoaderConfiguration;

public class RootLoader
extends ClassLoader {
    private InnerLoader inner;

    private RootLoader(ClassLoader parent) {
        super(parent);
    }

    public RootLoader(URL[] urls, ClassLoader parent) {
        this(parent);
        this.inner = new InnerLoader(urls);
    }

    public RootLoader(LoaderConfiguration lc) {
        this(RootLoader.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(this);
        this.inner = new InnerLoader(lc.getClassPathUrls());
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClassByName(name, false, resolve);
    }

    private Class loadClassByName(String name, boolean ignoreInner, boolean resolve) throws ClassNotFoundException {
        if (!ignoreInner) {
            try {
                return this.inner.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        return super.loadClass(name, true);
    }

    public URL getResource(String name) {
        URL url = this.inner.getResource(name);
        url = super.getResource(name);
        return url;
    }

    protected Enumeration findResources(String name) throws IOException {
        final Enumeration<URL> enum1 = this.inner.findResources(name);
        final Enumeration<URL> enum2 = super.findResources(name);
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enum1.hasMoreElements() || enum2.hasMoreElements();
            }

            public Object nextElement() {
                if (enum1.hasMoreElements()) {
                    return enum1.nextElement();
                }
                if (enum2.hasMoreElements()) {
                    return enum2.nextElement();
                }
                return null;
            }
        };
    }

    public void addURL(URL url) {
        this.inner.addPathEntry(url);
    }

    public URL[] getURLs() {
        return this.inner.getURLs();
    }

    private class InnerLoader
    extends URLClassLoader {
        public InnerLoader(URL[] urls) {
            super(urls, (ClassLoader)null);
        }

        public void addPathEntry(URL url) {
            this.addURL(url);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException cnfe) {
                return RootLoader.this.loadClassByName(name, true, resolve);
            }
        }
    }
}

