/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public abstract class AbstractOptionDialog
extends JDialog {
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    protected int m_action = 2;

    protected AbstractOptionDialog(JFrame frame, String title, int buttons) {
        super(frame, title, true);
        JButton button;
        AbstractAction action;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel backPane = new JPanel();
        backPane.setLayout(new BorderLayout());
        backPane.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 5, 0), new CompoundBorder(new EtchedBorder(1), new EmptyBorder(5, 5, 5, 5))));
        contentPane.add((Component)backPane, "Center");
        backPane.add((Component)new JLabel(this.getMessage(), 2), "North");
        JPanel mainPanel = this.getMainPanel();
        mainPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        backPane.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        Box buttonBox = Box.createHorizontalBox();
        if ((buttons & 1) != 0) {
            action = new AbstractAction("OK"){

                public void actionPerformed(ActionEvent event) {
                    if (AbstractOptionDialog.this.validateFields()) {
                        AbstractOptionDialog.this.m_action = 1;
                        AbstractOptionDialog.this.hide();
                    }
                }
            };
            button = new JButton(action);
            buttonBox.add(button);
            buttonBox.add(Box.createHorizontalStrut(5));
        }
        if ((buttons & 2) != 0) {
            action = new AbstractAction("Cancel"){

                public void actionPerformed(ActionEvent event) {
                    AbstractOptionDialog.this.m_action = 2;
                    AbstractOptionDialog.this.hide();
                }
            };
            button = new JButton(action);
            buttonBox.add(button);
            buttonBox.add(Box.createHorizontalStrut(5));
        }
        buttonPanel.add(buttonBox);
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
        Point frameLocation = frame.getLocation();
        Dimension frameSize = frame.getSize();
        Dimension size = this.getSize();
        this.setLocation((int)(frameLocation.getX() + (frameSize.getWidth() - size.getWidth()) / 2.0), (int)(frameLocation.getY() + (frameSize.getHeight() - size.getHeight()) / 2.0));
        this.setResizable(false);
    }

    protected abstract String getMessage();

    protected abstract JPanel getMainPanel();

    protected boolean validateFields() {
        return true;
    }

    public int getAction() {
        return this.m_action;
    }
}

