/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.excalibur.instrument.client.AbstractTabularOptionDialog;
import org.apache.excalibur.instrument.client.InstrumentClientFrame;
import org.apache.excalibur.instrument.client.InstrumentSampleUtils;

class CreateSampleDialog
extends AbstractTabularOptionDialog {
    private int m_instrumentType;
    private JTextField m_instrumentNameField;
    private JTextField m_instrumentDescriptionField;
    private JTextField m_sampleDescriptionField;
    private String m_sampleDescription;
    private String m_lastDefaultDescription;
    private JTextField m_intervalField;
    private long m_interval;
    private JTextField m_sizeField;
    private int m_size;
    private JTextField m_leaseTimeField;
    private long m_leaseTime;
    private JCheckBox m_maintainLeaseCheckBox;
    private Container m_sampleTypePanel;
    private ButtonGroup m_sampleTypeGroup;
    private int m_sampleType;
    private JRadioButton m_sampleTypeCounter;
    private JRadioButton m_sampleTypeMaximum;
    private JRadioButton m_sampleTypeMinimum;
    private JRadioButton m_sampleTypeMean;

    CreateSampleDialog(InstrumentClientFrame frame, String name, String description, int type) {
        super(frame, "Create Instrument Sample", 3);
        this.m_instrumentType = type;
        this.m_instrumentNameField.setText(name);
        this.m_instrumentDescriptionField.setText(description);
        this.buildSampleTypeComponent();
        this.setInterval(1000L);
        this.setSampleCount(600);
        this.setLeaseTime(600L);
        this.setMaintainLease(true);
        this.m_lastDefaultDescription = InstrumentSampleUtils.getDefaultDescriptionForType(this.m_sampleType, this.m_interval);
        this.setSampleDescription(this.m_lastDefaultDescription);
        this.pack();
    }

    protected String getMessage() {
        return "Please enter the parameters for the sample to be created.";
    }

    protected boolean validateFields() {
        return this.validateFields(false);
    }

    protected String[] getMainPanelLabels() {
        return new String[]{"Instrument Name:", "Instrument Description:", "Sample Description:", "Sample Interval (milliseconds):", "Number of Samples:", "Lease Time (Seconds):", "Maintain Lease:", "Sample Type:"};
    }

    protected Component[] getMainPanelComponents() {
        DocumentListener dl = new DocumentListener(){

            public void changedUpdate(DocumentEvent event) {
            }

            public void insertUpdate(DocumentEvent event) {
                CreateSampleDialog.this.validateFields(true);
            }

            public void removeUpdate(DocumentEvent event) {
                if (CreateSampleDialog.this.m_sampleDescriptionField.getText().length() > 0) {
                    CreateSampleDialog.this.validateFields(true);
                }
            }
        };
        this.m_instrumentNameField = new JTextField();
        this.m_instrumentNameField.setColumns(40);
        this.m_instrumentNameField.setEditable(false);
        this.m_instrumentDescriptionField = new JTextField();
        this.m_instrumentDescriptionField.setColumns(40);
        this.m_instrumentDescriptionField.setEditable(false);
        this.m_sampleDescriptionField = new JTextField();
        this.m_sampleDescriptionField.setColumns(40);
        this.m_sampleDescriptionField.getDocument().addDocumentListener(dl);
        this.m_intervalField = new JTextField();
        this.m_intervalField.setColumns(10);
        this.m_intervalField.getDocument().addDocumentListener(dl);
        this.m_sizeField = new JTextField();
        this.m_sizeField.setColumns(4);
        this.m_sizeField.getDocument().addDocumentListener(dl);
        this.m_leaseTimeField = new JTextField();
        this.m_leaseTimeField.setColumns(10);
        this.m_leaseTimeField.getDocument().addDocumentListener(dl);
        this.m_maintainLeaseCheckBox = new JCheckBox();
        this.m_sampleTypePanel = Box.createVerticalBox();
        Box intervalBar = Box.createHorizontalBox();
        intervalBar.add(this.m_intervalField);
        intervalBar.add(Box.createHorizontalStrut(20));
        intervalBar.add(this.createIntervalButton("1 Second", 1000L, 600, 600L));
        intervalBar.add(Box.createHorizontalStrut(5));
        intervalBar.add(this.createIntervalButton("1 Minute", 60000L, 1440, 86400L));
        intervalBar.add(Box.createHorizontalStrut(5));
        intervalBar.add(this.createIntervalButton("1 Hour", 3600000L, 672, 86400L));
        Box leaseTimeBar = Box.createHorizontalBox();
        leaseTimeBar.add(this.m_leaseTimeField);
        leaseTimeBar.add(Box.createHorizontalStrut(20));
        leaseTimeBar.add(this.createLeaseTimeButton("10 Minutes", 600L));
        leaseTimeBar.add(Box.createHorizontalStrut(5));
        leaseTimeBar.add(this.createLeaseTimeButton("1 Hour", 3600L));
        leaseTimeBar.add(Box.createHorizontalStrut(5));
        leaseTimeBar.add(this.createLeaseTimeButton("1 Day", 86400L));
        return new Component[]{this.m_instrumentNameField, this.m_instrumentDescriptionField, this.m_sampleDescriptionField, intervalBar, this.m_sizeField, leaseTimeBar, this.m_maintainLeaseCheckBox, this.m_sampleTypePanel};
    }

    private JButton createIntervalButton(String label, final long interval, final int size, final long leaseTime) {
        AbstractAction action = new AbstractAction(label){

            public void actionPerformed(ActionEvent event) {
                CreateSampleDialog.this.setInterval(interval);
                CreateSampleDialog.this.setSampleCount(size);
                CreateSampleDialog.this.setLeaseTime(leaseTime);
            }
        };
        return new JButton(action);
    }

    private JButton createLeaseTimeButton(String label, final long leaseTime) {
        AbstractAction action = new AbstractAction(label){

            public void actionPerformed(ActionEvent event) {
                CreateSampleDialog.this.setLeaseTime(leaseTime);
            }
        };
        return new JButton(action);
    }

    private void buildSampleTypeComponent() {
        ChangeListener cl = new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                if (((JRadioButton)event.getSource()).isSelected()) {
                    CreateSampleDialog.this.validateFields(true);
                }
            }
        };
        this.m_sampleTypeGroup = new ButtonGroup();
        this.m_sampleTypeCounter = new JRadioButton("Count over each sample");
        this.m_sampleTypeMaximum = new JRadioButton("Maximum value over each sample");
        this.m_sampleTypeMinimum = new JRadioButton("Minumum value over each sample");
        this.m_sampleTypeMean = new JRadioButton("Mean value over each sample");
        switch (this.m_instrumentType) {
            case 1: {
                this.m_sampleTypePanel.add(this.m_sampleTypeCounter);
                this.m_sampleTypeGroup.add(this.m_sampleTypeCounter);
                this.m_sampleTypeCounter.setSelected(true);
                this.m_sampleType = 101;
                break;
            }
            case 2: {
                this.m_sampleTypePanel.add(this.m_sampleTypeMaximum);
                this.m_sampleTypeGroup.add(this.m_sampleTypeMaximum);
                this.m_sampleTypePanel.add(this.m_sampleTypeMinimum);
                this.m_sampleTypeGroup.add(this.m_sampleTypeMinimum);
                this.m_sampleTypePanel.add(this.m_sampleTypeMean);
                this.m_sampleTypeGroup.add(this.m_sampleTypeMean);
                this.m_sampleTypeMaximum.setSelected(true);
                this.m_sampleType = 103;
                break;
            }
        }
        this.m_sampleTypeCounter.addChangeListener(cl);
        this.m_sampleTypeMaximum.addChangeListener(cl);
        this.m_sampleTypeMinimum.addChangeListener(cl);
        this.m_sampleTypeMean.addChangeListener(cl);
    }

    void setSampleDescription(String sampleDescription) {
        this.m_sampleDescription = sampleDescription;
        this.m_sampleDescriptionField.setText(sampleDescription);
        this.validateFields(true);
    }

    String getSampleDescription() {
        return this.m_sampleDescription;
    }

    void setInterval(long interval) {
        this.m_interval = interval;
        this.m_intervalField.setText(Long.toString(interval));
        this.validateFields(true);
    }

    long getInterval() {
        return this.m_interval;
    }

    void setSampleCount(int size) {
        this.m_size = size;
        this.m_sizeField.setText(Integer.toString(size));
    }

    int getSampleCount() {
        return this.m_size;
    }

    void setLeaseTime(long leaseTime) {
        this.m_leaseTime = leaseTime;
        this.m_leaseTimeField.setText(Long.toString(leaseTime));
    }

    long getLeaseTime() {
        return this.m_leaseTime;
    }

    void setMaintainLease(boolean maintainLease) {
        this.m_maintainLeaseCheckBox.setSelected(maintainLease);
    }

    boolean getMaintainLease() {
        return this.m_maintainLeaseCheckBox.isSelected();
    }

    void setSampleType(int type) {
        this.m_sampleType = type;
        switch (type) {
            case 101: {
                this.m_sampleTypeCounter.setSelected(true);
                break;
            }
            case 103: {
                this.m_sampleTypeMaximum.setSelected(true);
                break;
            }
            case 104: {
                this.m_sampleTypeMean.setSelected(true);
                break;
            }
            case 102: {
                this.m_sampleTypeMinimum.setSelected(true);
                break;
            }
        }
        this.validateFields(true);
    }

    int getSampleType() {
        return this.m_sampleType;
    }

    private boolean validateFields(boolean quiet) {
        boolean intervalOk = true;
        long interval = 0L;
        try {
            interval = Long.parseLong(this.m_intervalField.getText().trim());
        }
        catch (NumberFormatException e) {
            intervalOk = false;
        }
        if (interval < 100L || interval > 86400000L) {
            intervalOk = false;
        }
        if (intervalOk) {
            this.m_interval = interval;
            this.m_intervalField.setForeground(null);
        } else {
            this.m_intervalField.setForeground(Color.red);
            if (!quiet) {
                JOptionPane.showMessageDialog(this, "Please enter a valid interval. (100ms - 24hrs, 86400000)", "Invalid interval", 0);
                return false;
            }
        }
        boolean sizeOk = true;
        int size = 0;
        try {
            size = Integer.parseInt(this.m_sizeField.getText().trim());
        }
        catch (NumberFormatException e) {
            sizeOk = false;
        }
        if (size < 1 || size > 2048) {
            sizeOk = false;
        }
        if (sizeOk) {
            this.m_size = size;
            this.m_sizeField.setForeground(null);
        } else {
            this.m_sizeField.setForeground(Color.red);
            if (!quiet) {
                JOptionPane.showMessageDialog(this, "Please enter a valid size. (1 - 2048)", "Invalid size", 0);
                return false;
            }
        }
        boolean leaseTimeOk = true;
        int leaseTime = 0;
        try {
            leaseTime = Integer.parseInt(this.m_leaseTimeField.getText().trim());
        }
        catch (NumberFormatException e) {
            leaseTimeOk = false;
        }
        if (leaseTime < 60 || (long)leaseTime > (long)size * interval / 1000L + 86400L) {
            leaseTimeOk = false;
        }
        if (leaseTimeOk) {
            this.m_leaseTime = (long)leaseTime * 1000L;
            this.m_leaseTimeField.setForeground(null);
        } else {
            this.m_leaseTimeField.setForeground(Color.red);
            if (!quiet) {
                JOptionPane.showMessageDialog(this, "Please enter a valid lease time. Must be between 1 minute (60) and 24 hours greater than the interval * size (" + ((long)size * interval / 1000L + 86400L) + ")", "Invalid leaseTime", 0);
                return false;
            }
        }
        this.m_sampleType = this.m_sampleTypeCounter.isSelected() ? 101 : (this.m_sampleTypeMaximum.isSelected() ? 103 : (this.m_sampleTypeMean.isSelected() ? 104 : (this.m_sampleTypeMinimum.isSelected() ? 102 : -1)));
        String newDefaultDescription = InstrumentSampleUtils.getDefaultDescriptionForType(this.m_sampleType, this.m_interval);
        String description = this.m_sampleDescriptionField.getText().trim();
        if ((description.length() == 0 || description.equals(this.m_lastDefaultDescription)) && !description.equals(newDefaultDescription)) {
            final String setDesc = description = newDefaultDescription;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CreateSampleDialog.this.m_sampleDescriptionField.setText(setDesc);
                }
            });
        }
        this.m_sampleDescription = description;
        this.m_lastDefaultDescription = newDefaultDescription;
        return true;
    }
}

