/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.instrument.client.InstrumentData;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.InstrumentManagerConnectionListener;
import org.apache.excalibur.instrument.client.InstrumentManagerData;
import org.apache.excalibur.instrument.client.InstrumentNodeData;
import org.apache.excalibur.instrument.client.InstrumentSampleData;
import org.apache.excalibur.instrument.client.InstrumentSampleNodeData;
import org.apache.excalibur.instrument.client.InstrumentableData;
import org.apache.excalibur.instrument.client.InstrumentableNodeData;
import org.apache.excalibur.instrument.client.MaintainedSampleLease;

class InstrumentManagerTreeModel
extends AbstractLogEnabled
implements InstrumentManagerConnectionListener,
TreeModel {
    private final InstrumentManagerConnection m_connection;
    private int m_lastClientStateVersion;
    private boolean m_lastConnected = false;
    private DefaultMutableTreeNode m_root;
    private ArrayList m_listeners = new ArrayList();
    private TreeModelListener[] m_listenerArray;
    private HashMap m_elementMap = new HashMap();
    private HashMap m_leasedSampleMap = new HashMap();
    private DefaultMutableTreeNode[] m_leasedSampleArray;

    InstrumentManagerTreeModel(InstrumentManagerConnection connection) {
        this.m_connection = connection;
        this.m_root = new DefaultMutableTreeNode("Root");
    }

    public void opened(InstrumentManagerConnection connection) {
        this.getLogger().debug("InstrumentManagerTreeModel.opened(" + connection + ")");
        this.refreshModel();
    }

    public void closed(InstrumentManagerConnection connection) {
        this.getLogger().debug("InstrumentManagerTreeModel.closed(" + connection + ")");
        this.refreshModel();
    }

    public void deleted(InstrumentManagerConnection connection) {
        this.getLogger().debug("InstrumentManagerTreeModel.deleted(" + connection + ")");
        this.refreshModel();
    }

    public Object getRoot() {
        return this.m_root;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent;
            return node.getChildAt(index);
        }
        return "---";
    }

    public int getChildCount(Object parent) {
        if (parent instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent;
            return node.getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        if (node == this.m_root) {
            return false;
        }
        if (node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode inode = (DefaultMutableTreeNode)node;
            return inode.isLeaf();
        }
        return true;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent;
            return node.getIndex((DefaultMutableTreeNode)child);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeModelListener(TreeModelListener listener) {
        InstrumentManagerTreeModel instrumentManagerTreeModel = this;
        synchronized (instrumentManagerTreeModel) {
            this.m_listeners.add(listener);
            this.m_listenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTreeModelListener(TreeModelListener listener) {
        InstrumentManagerTreeModel instrumentManagerTreeModel = this;
        synchronized (instrumentManagerTreeModel) {
            this.m_listeners.remove(listener);
            this.m_listenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeModelListener[] getListeners() {
        TreeModelListener[] listeners = this.m_listenerArray;
        if (listeners == null) {
            InstrumentManagerTreeModel instrumentManagerTreeModel = this;
            synchronized (instrumentManagerTreeModel) {
                this.m_listenerArray = new TreeModelListener[this.m_listeners.size()];
                this.m_listeners.toArray(this.m_listenerArray);
                listeners = this.m_listenerArray;
            }
        }
        return listeners;
    }

    private void fireTreeNodesChanged(TreeModelEvent event) {
        TreeModelListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].treeNodesChanged(event);
        }
    }

    private void fireTreeNodesInserted(TreeModelEvent event) {
        TreeModelListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].treeNodesInserted(event);
        }
    }

    private void fireTreeNodesRemoved(TreeModelEvent event) {
        TreeModelListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].treeNodesRemoved(event);
        }
    }

    private void fireTreeStructureChanged(TreeModelEvent event) {
        TreeModelListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].treeStructureChanged(event);
        }
    }

    public DefaultMutableTreeNode getInstrumentableTreeNode(String name) {
        Object element;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_elementMap.get(name);
        if (node != null && (element = node.getUserObject()) instanceof InstrumentableNodeData) {
            return node;
        }
        return null;
    }

    public DefaultMutableTreeNode getInstrumentTreeNode(String name) {
        Object element;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_elementMap.get(name);
        if (node != null && (element = node.getUserObject()) instanceof InstrumentNodeData) {
            return node;
        }
        return null;
    }

    public DefaultMutableTreeNode getInstrumentSampleTreeNode(String name) {
        Object element;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_elementMap.get(name);
        if (node != null && (element = node.getUserObject()) instanceof InstrumentSampleNodeData) {
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultMutableTreeNode[] getLeasedSampleArray() {
        DefaultMutableTreeNode[] leasedSampleArray = this.m_leasedSampleArray;
        if (leasedSampleArray == null) {
            InstrumentManagerTreeModel instrumentManagerTreeModel = this;
            synchronized (instrumentManagerTreeModel) {
                this.m_leasedSampleArray = new DefaultMutableTreeNode[this.m_leasedSampleMap.size()];
                this.m_leasedSampleMap.values().toArray(this.m_leasedSampleArray);
                leasedSampleArray = this.m_leasedSampleArray;
            }
        }
        return leasedSampleArray;
    }

    void renewAllSampleLeases() {
        DefaultMutableTreeNode[] leasedSampleArray = this.getLeasedSampleArray();
        for (int i = 0; i < leasedSampleArray.length; ++i) {
            InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)leasedSampleArray[i].getUserObject();
            InstrumentSampleData sample = sampleNodeData.getData();
            this.updateInstrumentSample(sample);
        }
    }

    void purgeExpiredSamples() {
        DefaultMutableTreeNode[] leasedSampleArray = this.getLeasedSampleArray();
        for (int i = 0; i < leasedSampleArray.length; ++i) {
            InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)leasedSampleArray[i].getUserObject();
            if (sampleNodeData.getRemainingLeaseTime() >= 0L) continue;
            DefaultMutableTreeNode instrumentTreeNode = (DefaultMutableTreeNode)leasedSampleArray[i].getParent();
            InstrumentData instrumentData = ((InstrumentNodeData)instrumentTreeNode.getUserObject()).getData();
            this.updateInstrument(instrumentData, instrumentTreeNode, -1);
        }
    }

    void refreshModel() {
        if (this.m_connection.isConnected() != this.m_lastConnected) {
            this.m_root.removeAllChildren();
            this.m_elementMap.clear();
            this.m_leasedSampleMap.clear();
            this.m_leasedSampleArray = null;
            this.m_lastClientStateVersion = -1;
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.m_root.getPath()));
        }
        if (this.m_connection.isConnected()) {
            this.updateInstrumentManagerData(this.m_connection.getInstrumentManager(), this.m_root, this.m_lastClientStateVersion);
        }
        this.m_lastConnected = this.m_connection.isConnected();
    }

    private void updateInstrumentManagerData(InstrumentManagerData manager, DefaultMutableTreeNode rootTreeNode, int oldStateVersion) {
        int i;
        int stateVersion = manager.getStateVersion();
        if (stateVersion == oldStateVersion) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("update manager(" + manager.getName() + ") " + "state new=" + stateVersion + ", old=" + oldStateVersion);
        }
        InstrumentableData[] instrumentables = manager.getInstrumentables();
        for (i = 0; i < instrumentables.length; ++i) {
            InstrumentableData instrumentable = instrumentables[i];
            int oldInstrumentableStateVersion = -1;
            DefaultMutableTreeNode newChild = null;
            int childCount = rootTreeNode.getChildCount();
            if (i < childCount) {
                int cmp;
                do {
                    DefaultMutableTreeNode oldChild;
                    if ((cmp = ((InstrumentableNodeData)(oldChild = (DefaultMutableTreeNode)rootTreeNode.getChildAt(i)).getUserObject()).getDescription().compareTo(instrumentable.getDescription())) == 0) {
                        InstrumentableNodeData nodeData = (InstrumentableNodeData)oldChild.getUserObject();
                        oldInstrumentableStateVersion = nodeData.getStateVersion();
                        if (nodeData.update()) {
                            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, rootTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                        }
                        newChild = oldChild;
                        continue;
                    }
                    if (cmp > 0) {
                        newChild = new DefaultMutableTreeNode(new InstrumentableNodeData(instrumentable), true);
                        rootTreeNode.insert(newChild, i);
                        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, rootTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                        this.m_elementMap.put(((InstrumentableNodeData)newChild.getUserObject()).getName(), newChild);
                        continue;
                    }
                    if (cmp >= 0) continue;
                    rootTreeNode.remove(i);
                    this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, rootTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                    this.m_elementMap.remove(((InstrumentableNodeData)oldChild.getUserObject()).getName());
                } while (cmp < 0);
            } else {
                newChild = new DefaultMutableTreeNode(new InstrumentableNodeData(instrumentable), true);
                rootTreeNode.insert(newChild, i);
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, rootTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                this.m_elementMap.put(((InstrumentableNodeData)newChild.getUserObject()).getName(), newChild);
            }
            this.updateInstrumentable(instrumentable, newChild, oldInstrumentableStateVersion);
        }
        while (i < rootTreeNode.getChildCount()) {
            DefaultMutableTreeNode oldChild = (DefaultMutableTreeNode)rootTreeNode.getChildAt(i);
            rootTreeNode.remove(i);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, rootTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
            this.m_elementMap.remove(((InstrumentableNodeData)oldChild.getUserObject()).getName());
        }
        this.m_lastClientStateVersion = stateVersion;
    }

    private void updateInstrumentable(InstrumentableData instrumentableData, DefaultMutableTreeNode instrumentableTreeNode, int oldStateVersion) {
        DefaultMutableTreeNode oldChild;
        int i;
        int stateVersion = instrumentableData.getStateVersion();
        if (stateVersion == oldStateVersion) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("update instrumentable(" + instrumentableData.getName() + ") " + "state new=" + stateVersion + ", old=" + oldStateVersion);
        }
        InstrumentableData[] childInstrumentables = instrumentableData.getInstrumentables();
        for (i = 0; i < childInstrumentables.length; ++i) {
            InstrumentableData childInstrumentable = childInstrumentables[i];
            int oldInstrumentableStateVersion = -1;
            DefaultMutableTreeNode newChild = null;
            int childCount = instrumentableTreeNode.getChildCount();
            if (i < childCount) {
                int cmp;
                do {
                    DefaultMutableTreeNode oldChild2;
                    if ((cmp = (oldChild2 = (DefaultMutableTreeNode)instrumentableTreeNode.getChildAt(i)).getUserObject() instanceof InstrumentableNodeData ? ((InstrumentableNodeData)oldChild2.getUserObject()).getDescription().compareTo(childInstrumentable.getDescription()) : 1) == 0) {
                        InstrumentableNodeData nodeData = (InstrumentableNodeData)oldChild2.getUserObject();
                        oldInstrumentableStateVersion = nodeData.getStateVersion();
                        if (nodeData.update()) {
                            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild2}));
                        }
                        newChild = oldChild2;
                        continue;
                    }
                    if (cmp > 0) {
                        newChild = new DefaultMutableTreeNode(new InstrumentableNodeData(childInstrumentable), true);
                        instrumentableTreeNode.insert(newChild, i);
                        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                        this.m_elementMap.put(((InstrumentableNodeData)newChild.getUserObject()).getName(), newChild);
                        continue;
                    }
                    if (cmp >= 0) continue;
                    instrumentableTreeNode.remove(i);
                    this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild2}));
                    this.m_elementMap.remove(((InstrumentableNodeData)oldChild2.getUserObject()).getName());
                } while (cmp < 0);
            } else {
                newChild = new DefaultMutableTreeNode(new InstrumentableNodeData(childInstrumentable), true);
                instrumentableTreeNode.insert(newChild, i);
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                this.m_elementMap.put(((InstrumentableNodeData)newChild.getUserObject()).getName(), newChild);
            }
            this.updateInstrumentable(childInstrumentable, newChild, oldInstrumentableStateVersion);
        }
        while (i < instrumentableTreeNode.getChildCount() && (oldChild = (DefaultMutableTreeNode)instrumentableTreeNode.getChildAt(i)).getUserObject() instanceof InstrumentableNodeData) {
            instrumentableTreeNode.remove(i);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
            this.m_elementMap.remove(((InstrumentableNodeData)oldChild.getUserObject()).getName());
        }
        InstrumentData[] instruments = instrumentableData.getInstruments();
        for (i = childInstrumentables.length; i < instruments.length + childInstrumentables.length; ++i) {
            InstrumentData instrument = instruments[i - childInstrumentables.length];
            int oldInstrumentStateVersion = -1;
            DefaultMutableTreeNode newChild = null;
            int childCount = instrumentableTreeNode.getChildCount();
            if (i < childCount) {
                int cmp;
                do {
                    DefaultMutableTreeNode oldChild3;
                    if ((cmp = (oldChild3 = (DefaultMutableTreeNode)instrumentableTreeNode.getChildAt(i)).getUserObject() instanceof InstrumentNodeData ? ((InstrumentNodeData)oldChild3.getUserObject()).getDescription().compareTo(instrument.getDescription()) : 1) == 0) {
                        InstrumentNodeData nodeData = (InstrumentNodeData)oldChild3.getUserObject();
                        oldInstrumentStateVersion = nodeData.getStateVersion();
                        if (nodeData.update()) {
                            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild3}));
                        }
                        newChild = oldChild3;
                        continue;
                    }
                    if (cmp > 0) {
                        newChild = new DefaultMutableTreeNode(new InstrumentNodeData(instrument, this.m_connection), true);
                        instrumentableTreeNode.insert(newChild, i);
                        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                        this.m_elementMap.put(((InstrumentNodeData)newChild.getUserObject()).getName(), newChild);
                        continue;
                    }
                    if (cmp >= 0) continue;
                    instrumentableTreeNode.remove(i);
                    this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild3}));
                    this.m_elementMap.remove(((InstrumentNodeData)oldChild3.getUserObject()).getName());
                } while (cmp < 0);
            } else {
                newChild = new DefaultMutableTreeNode(new InstrumentNodeData(instrument, this.m_connection), true);
                instrumentableTreeNode.insert(newChild, i);
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                this.m_elementMap.put(((InstrumentNodeData)newChild.getUserObject()).getName(), newChild);
            }
            this.updateInstrument(instrument, newChild, oldInstrumentStateVersion);
        }
        while (i < instrumentableTreeNode.getChildCount()) {
            DefaultMutableTreeNode oldChild4 = (DefaultMutableTreeNode)instrumentableTreeNode.getChildAt(i);
            instrumentableTreeNode.remove(i);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentableTreeNode.getPath(), new int[]{i}, new Object[]{oldChild4}));
            this.m_elementMap.remove(((InstrumentNodeData)oldChild4.getUserObject()).getName());
        }
    }

    void updateInstrument(InstrumentData instrumentData) {
        DefaultMutableTreeNode instrumentTreeNode = this.getInstrumentTreeNode(instrumentData.getName());
        if (instrumentTreeNode != null) {
            this.updateInstrument(instrumentData, instrumentTreeNode, -1);
        }
    }

    void updateInstrument(InstrumentData instrumentData, DefaultMutableTreeNode instrumentTreeNode, int oldStateVersion) {
        int i;
        int stateVersion = instrumentData.getStateVersion();
        if (stateVersion == oldStateVersion) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("update instrument(" + instrumentData.getName() + ") " + "state new=" + stateVersion + ", old=" + oldStateVersion);
        }
        InstrumentSampleData[] samples = instrumentData.getInstrumentSamples();
        for (i = 0; i < samples.length; ++i) {
            MaintainedSampleLease lease;
            InstrumentSampleData sample = samples[i];
            DefaultMutableTreeNode newChild = null;
            int childCount = instrumentTreeNode.getChildCount();
            if (i < childCount) {
                int cmp;
                do {
                    String sampleName;
                    DefaultMutableTreeNode oldChild;
                    if ((cmp = ((InstrumentSampleNodeData)(oldChild = (DefaultMutableTreeNode)instrumentTreeNode.getChildAt(i)).getUserObject()).getDescription().compareTo(sample.getDescription())) == 0) {
                        if (((InstrumentSampleNodeData)oldChild.getUserObject()).update()) {
                            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, instrumentTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                        }
                        newChild = oldChild;
                        continue;
                    }
                    if (cmp > 0) {
                        MaintainedSampleLease lease2;
                        newChild = new DefaultMutableTreeNode(new InstrumentSampleNodeData(instrumentData.getName(), sample, this.m_connection), true);
                        instrumentTreeNode.insert(newChild, i);
                        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
                        InstrumentSampleNodeData newNodeData = (InstrumentSampleNodeData)newChild.getUserObject();
                        sampleName = newNodeData.getName();
                        this.m_elementMap.put(sampleName, newChild);
                        if (newNodeData.isLeased()) {
                            this.m_leasedSampleMap.put(sampleName, newChild);
                            this.m_leasedSampleArray = null;
                        }
                        if ((lease2 = this.m_connection.getMaintainedSampleLease(sampleName)) == null) continue;
                        newNodeData.setLeaseDuration(lease2.getLeaseDuration());
                        continue;
                    }
                    if (cmp >= 0) continue;
                    instrumentTreeNode.remove(i);
                    this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
                    InstrumentSampleNodeData oldNodeData = (InstrumentSampleNodeData)oldChild.getUserObject();
                    sampleName = oldNodeData.getName();
                    this.m_elementMap.remove(sampleName);
                    if (!oldNodeData.isLeased()) continue;
                    this.m_leasedSampleMap.remove(sampleName);
                    this.m_leasedSampleArray = null;
                } while (cmp < 0);
                continue;
            }
            newChild = new DefaultMutableTreeNode(new InstrumentSampleNodeData(instrumentData.getName(), sample, this.m_connection), true);
            instrumentTreeNode.insert(newChild, i);
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, instrumentTreeNode.getPath(), new int[]{i}, new Object[]{newChild}));
            InstrumentSampleNodeData newNodeData = (InstrumentSampleNodeData)newChild.getUserObject();
            String sampleName = newNodeData.getName();
            this.m_elementMap.put(sampleName, newChild);
            if (newNodeData.isLeased()) {
                this.m_leasedSampleMap.put(sampleName, newChild);
                this.m_leasedSampleArray = null;
            }
            if ((lease = this.m_connection.getMaintainedSampleLease(sampleName)) == null) continue;
            newNodeData.setLeaseDuration(lease.getLeaseDuration());
        }
        while (i < instrumentTreeNode.getChildCount()) {
            DefaultMutableTreeNode oldChild = (DefaultMutableTreeNode)instrumentTreeNode.getChildAt(i);
            instrumentTreeNode.remove(i);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, instrumentTreeNode.getPath(), new int[]{i}, new Object[]{oldChild}));
            InstrumentSampleNodeData oldNodeData = (InstrumentSampleNodeData)oldChild.getUserObject();
            String sampleName = oldNodeData.getName();
            this.m_elementMap.remove(sampleName);
            if (!oldNodeData.isLeased()) continue;
            this.m_leasedSampleMap.remove(sampleName);
            this.m_leasedSampleArray = null;
        }
    }

    void updateInstrumentSample(InstrumentSampleData sampleData) {
        DefaultMutableTreeNode sampleTreeNode = this.getInstrumentSampleTreeNode(sampleData.getName());
        if (sampleTreeNode != null) {
            this.updateInstrumentSample(sampleData, sampleTreeNode);
        }
    }

    void updateInstrumentSample(InstrumentSampleData sampleData, DefaultMutableTreeNode sampleTreeNode) {
        ((InstrumentSampleNodeData)sampleTreeNode.getUserObject()).update();
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, sampleTreeNode.getPath(), new int[0], new Object[0]));
    }
}

