/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.excalibur.instrument.client.AbstractInternalFrame;
import org.apache.excalibur.instrument.client.InstrumentClientFrame;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.InstrumentSampleNodeData;
import org.apache.excalibur.instrument.client.InstrumentSampleSnapshotData;
import org.apache.excalibur.instrument.client.LineChart;
import org.apache.excalibur.instrument.client.NodeData;

public class InstrumentSampleFrame
extends AbstractInternalFrame {
    public static final String FRAME_TYPE = "sample-frame";
    private static final int STATE_NONE = 0;
    private static final int STATE_DISCONNECTED = 1;
    private static final int STATE_MISSING = 2;
    private static final int STATE_SNAPSHOT = 3;
    private static final int STATE_EXPIRED = 4;
    private static final ImageIcon m_iconDisconnected;
    private static final ImageIcon m_iconMissing;
    private static final ImageIcon m_iconExpired;
    private int m_state = 0;
    private InstrumentManagerConnection m_connection;
    private String m_instrumentSampleName;
    private String m_fullName;
    private long m_lastSnapshotTime;
    private int[] m_samples;
    private LineChart m_lineChart;
    static /* synthetic */ Class class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer;

    InstrumentSampleFrame(Configuration stateConfig, InstrumentManagerConnection connection, InstrumentClientFrame frame) throws ConfigurationException {
        super(stateConfig, true, true, true, true, frame);
        this.m_fullName = this.m_instrumentSampleName = stateConfig.getAttribute("sample");
        this.m_connection = connection;
    }

    InstrumentSampleFrame(InstrumentManagerConnection connection, String sampleName, InstrumentClientFrame frame) {
        super("", true, true, true, true, frame);
        this.m_connection = connection;
        this.m_fullName = this.m_instrumentSampleName = sampleName;
        this.setSize(new Dimension(600, 120));
    }

    protected void getState(DefaultConfiguration stateConfig) {
        stateConfig.setAttribute("type", FRAME_TYPE);
        stateConfig.setAttribute("url", this.m_connection.getKey().toString());
        stateConfig.setAttribute("sample", this.m_instrumentSampleName);
    }

    void hideFrame() {
        super.hideFrame();
    }

    public void internalFrameClosed(InternalFrameEvent event) {
        this.m_connection.hideSampleFrame(this);
        super.internalFrameClosed(event);
    }

    public String getInstrumentSampleName() {
        return this.m_instrumentSampleName;
    }

    public long getLastSnapshotTime() {
        return this.m_lastSnapshotTime;
    }

    private void updateIcon() {
        ImageIcon icon;
        DefaultMutableTreeNode sampleNode = this.m_connection.getInstrumentSampleTreeNode(this.m_instrumentSampleName);
        if (sampleNode != null) {
            InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)sampleNode.getUserObject();
            icon = sampleNodeData.getIcon();
        } else {
            icon = this.m_state == 2 ? m_iconMissing : (this.m_state == 4 ? m_iconExpired : m_iconDisconnected);
        }
        if (this.getFrameIcon() != icon) {
            this.setFrameIcon(icon);
        }
    }

    private void updateTitle() {
        StringBuffer sb;
        DefaultMutableTreeNode sampleNode = this.m_connection.getInstrumentSampleTreeNode(this.m_instrumentSampleName);
        if (sampleNode != null) {
            sb = new StringBuffer();
            InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)sampleNode.getUserObject();
            sb.append(sampleNodeData.getDescription());
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)sampleNode.getParent();
            while (parentNode != null) {
                Object userObject = parentNode.getUserObject();
                if (userObject == null || !(userObject instanceof NodeData)) {
                    parentNode = null;
                    continue;
                }
                sb.append(" / ");
                sb.append(((NodeData)userObject).getDescription());
                parentNode = (DefaultMutableTreeNode)parentNode.getParent();
            }
            this.m_fullName = sb.toString();
        }
        sb = new StringBuffer();
        switch (this.m_state) {
            case 3: {
                break;
            }
            case 2: {
                sb.append("[Missing] ");
                break;
            }
            case 4: {
                sb.append("[Expired] ");
                break;
            }
            default: {
                sb.append("[Disconnected] ");
            }
        }
        sb.append(this.m_fullName);
        sb.append(" / ");
        sb.append(this.m_connection.getTitle());
        String title = sb.toString();
        if (!this.getTitle().equals(title)) {
            this.setTitle(title);
        }
    }

    private void initChart(InstrumentSampleSnapshotData snapshot) {
        String detailFormat;
        String format;
        int hInterval;
        long interval = Math.max(1L, snapshot.getInterval());
        if (interval < 1000L) {
            hInterval = (int)(10000L / interval);
            format = "{3}:{4}:{5}";
            detailFormat = "{1}/{2} {3}:{4}:{5}.{6}";
        } else if (interval < 60000L) {
            hInterval = (int)(60000L / interval);
            format = "{3}:{4}:{5}";
            detailFormat = "{1}/{2} {3}:{4}:{5}";
        } else if (interval < 600000L) {
            hInterval = (int)(600000L / interval);
            format = "{1}/{2} {3}:{4}";
            detailFormat = "{1}/{2} {3}:{4}";
        } else if (interval < 3600000L) {
            hInterval = (int)(3600000L / interval);
            format = "{1}/{2} {3}:{4}";
            detailFormat = "{1}/{2} {3}:{4}";
        } else if (interval < 86400000L) {
            hInterval = (int)(86400000L / interval);
            format = "{1}/{2}";
            detailFormat = "{1}/{2} {3}:{4}";
        } else if (interval < 604800000L) {
            hInterval = (int)(604800000L / interval);
            format = "{0}/{1}/{2}";
            detailFormat = "{0}/{1}/{2}";
        } else {
            hInterval = 10;
            format = "{0}/{1}/{2}";
            detailFormat = "{0}/{1}/{2}";
        }
        this.getContentPane().removeAll();
        this.m_lineChart = new LineChart(hInterval, interval, format, detailFormat, 20, this.getFrame().isAntialias());
        this.getContentPane().add(this.m_lineChart);
    }

    private void setStateSnapshot(InstrumentSampleSnapshotData snapshot) {
        if (this.m_state != 3) {
            this.initChart(snapshot);
            this.m_state = 3;
            this.updateTitle();
        }
        int size = snapshot.getSize();
        int[] newSamples = snapshot.getSamples();
        if (newSamples.length == size) {
            this.m_samples = newSamples;
        } else if (newSamples.length > size) {
            this.m_samples = new int[size];
            System.arraycopy(newSamples, newSamples.length - size, this.m_samples, 0, size);
        } else {
            if (this.m_samples == null) {
                this.m_samples = new int[size];
            } else if (this.m_samples.length != size) {
                int[] tmpSamples = new int[size];
                if (this.m_samples.length > size) {
                    System.arraycopy(this.m_samples, this.m_samples.length - size, tmpSamples, 0, size);
                } else {
                    System.arraycopy(this.m_samples, 0, tmpSamples, size - this.m_samples.length, this.m_samples.length);
                }
                this.m_samples = tmpSamples;
            }
            long age = snapshot.getTime() - this.m_lastSnapshotTime;
            int intervalAge = (int)(age / snapshot.getInterval());
            if (intervalAge > this.m_samples.length) {
                intervalAge = this.m_samples.length;
            }
            if (intervalAge > 0 && intervalAge < this.m_samples.length) {
                System.arraycopy(this.m_samples, intervalAge, this.m_samples, 0, size - intervalAge);
            }
            if (intervalAge > newSamples.length) {
                for (int i = size - intervalAge; i < size - newSamples.length; ++i) {
                    this.m_samples[i] = 0;
                }
            }
            System.arraycopy(newSamples, 0, this.m_samples, size - newSamples.length, newSamples.length);
        }
        this.m_lineChart.setValues(this.m_samples, snapshot.getTime());
        this.m_lastSnapshotTime = snapshot.getTime();
        this.updateIcon();
    }

    private void setStateDisconnected() {
        if (this.m_state != 1) {
            this.getContentPane().removeAll();
            JLabel label = new JLabel("Not connected");
            label.setForeground(Color.red);
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(0);
            this.getContentPane().add(label);
            this.m_state = 1;
            this.updateTitle();
            this.updateIcon();
        }
    }

    private void setStateSampleMissing() {
        if (this.m_state != 2) {
            this.getContentPane().removeAll();
            JLabel label = new JLabel("Sample not found");
            label.setForeground(Color.red);
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(0);
            this.getContentPane().add(label);
            this.m_state = 2;
            this.updateTitle();
            this.updateIcon();
        }
    }

    private void setStateSampleExpired() {
        if (this.m_state != 4) {
            this.m_lineChart.setBackground(new Color(220, 220, 220));
            this.m_lineChart.repaint();
            this.m_state = 4;
            this.updateTitle();
            this.updateIcon();
        }
    }

    public void updateSnapshot(InstrumentSampleSnapshotData snapshot) {
        if (this.m_connection.isDeleted()) {
            this.hideFrame();
        } else {
            if (this.m_lineChart != null) {
                this.m_lineChart.setAntialias(this.getFrame().isAntialias());
            }
            if (snapshot == null) {
                if (!this.m_connection.isConnected()) {
                    this.setStateDisconnected();
                } else if (this.m_state == 3 || this.m_state == 4) {
                    this.setStateSampleExpired();
                } else {
                    this.setStateSampleMissing();
                }
            } else {
                this.setStateSnapshot(snapshot);
            }
        }
    }

    void update() {
        InstrumentSampleSnapshotData snapshot = null;
        if (!this.m_connection.isDeleted()) {
            snapshot = this.m_connection.getSampleSnapshot(this.m_instrumentSampleName);
        }
        this.updateSnapshot(snapshot);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassLoader cl = (class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer == null ? (class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer = InstrumentSampleFrame.class$("org.apache.excalibur.instrument.client.InstrumentManagerTreeCellRenderer")) : class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer).getClassLoader();
        m_iconDisconnected = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/sample_disconnected.gif"));
        m_iconMissing = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/sample_missing.gif"));
        m_iconExpired = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/sample_expired.gif"));
    }
}

