/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.excalibur.instrument.client.InstrumentClientFrame;
import org.apache.excalibur.instrument.client.InstrumentData;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.InstrumentManagerData;
import org.apache.excalibur.instrument.client.InstrumentSampleData;
import org.apache.excalibur.instrument.client.InstrumentableData;
import org.apache.excalibur.instrument.client.LargeMenu;

public class MenuBar
extends JMenuBar {
    protected InstrumentClientFrame m_frame;
    boolean m_showUnconfigured = true;
    private JMenu m_menuFile;
    private JMenu m_menuInstrumentManagers;
    private JMenu m_menuOptions;
    private JCheckBoxMenuItem m_menuItemShowUnconfigured;
    private JMenu m_menuWindow;

    MenuBar(InstrumentClientFrame frame) {
        this.m_frame = frame;
        this.add(this.buildFileMenu());
        this.add(this.buildInstrumentManagerMenu());
        this.add(this.buildOptionsMenu());
        this.add(this.buildWindowMenu());
    }

    private JMenu buildFileMenu() {
        this.m_menuFile = new LargeMenu("File");
        this.m_menuFile.setMnemonic('F');
        AbstractAction newAction = new AbstractAction("New"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.fileNew();
            }
        };
        JMenuItem newItem = new JMenuItem(newAction);
        newItem.setMnemonic('N');
        this.m_menuFile.add(newItem);
        AbstractAction openAction = new AbstractAction("Open ..."){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.fileOpen();
            }
        };
        JMenuItem open = new JMenuItem(openAction);
        open.setMnemonic('O');
        this.m_menuFile.add(open);
        this.m_menuFile.addSeparator();
        AbstractAction saveAction = new AbstractAction("Save"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.fileSave();
            }
        };
        JMenuItem save = new JMenuItem(saveAction);
        save.setMnemonic('S');
        this.m_menuFile.add(save);
        AbstractAction saveAsAction = new AbstractAction("Save As ..."){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.fileSaveAs();
            }
        };
        JMenuItem saveAs = new JMenuItem(saveAsAction);
        saveAs.setMnemonic('A');
        this.m_menuFile.add(saveAs);
        this.m_menuFile.addSeparator();
        AbstractAction exitAction = new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.fileExit();
            }
        };
        JMenuItem exit = new JMenuItem(exitAction);
        exit.setMnemonic('X');
        this.m_menuFile.add(exit);
        return this.m_menuFile;
    }

    private JMenu buildInstrumentManagerMenu() {
        this.m_menuInstrumentManagers = new LargeMenu("Instrument Managers");
        this.m_menuInstrumentManagers.setMnemonic('I');
        this.m_menuInstrumentManagers.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent event) {
                MenuBar.this.rebuildInstrumentManagersMenu();
            }

            public void menuDeselected(MenuEvent event) {
            }

            public void menuCanceled(MenuEvent event) {
            }
        });
        return this.m_menuInstrumentManagers;
    }

    private void rebuildInstrumentManagersMenu() {
        this.m_menuInstrumentManagers.removeAll();
        AbstractAction connectAction = new AbstractAction("Connect to Instrument Manager..."){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.showConnectDialog();
            }
        };
        JMenuItem connectItem = new JMenuItem(connectAction);
        connectItem.setMnemonic('C');
        this.m_menuInstrumentManagers.add(connectItem);
        InstrumentManagerConnection[] connections = this.m_frame.getConnections();
        if (connections.length > 0) {
            this.m_menuInstrumentManagers.addSeparator();
            for (int i = 0; i < connections.length; ++i) {
                InstrumentManagerConnection connection = connections[i];
                AbstractAction action = new AbstractAction(connection.getTitle()){

                    public void actionPerformed(ActionEvent event) {
                    }
                };
                action.putValue("InstrumentManagerConnection", connection);
                LargeMenu menu = new LargeMenu(action);
                menu.addMenuListener(new MenuListener(){

                    public void menuSelected(MenuEvent event) {
                        JMenu menu = (JMenu)event.getSource();
                        Action action = menu.getAction();
                        MenuBar.this.rebuildInstrumentManagerMenu(menu, (InstrumentManagerConnection)action.getValue("InstrumentManagerConnection"));
                    }

                    public void menuDeselected(MenuEvent event) {
                    }

                    public void menuCanceled(MenuEvent event) {
                    }
                });
                this.m_menuInstrumentManagers.add(menu);
            }
        }
    }

    private void rebuildInstrumentManagerMenu(JMenu managerMenu, InstrumentManagerConnection connection) {
        managerMenu.removeAll();
        boolean showAll = this.m_showUnconfigured;
        AbstractAction deleteAction = new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent event) {
                JMenuItem item = (JMenuItem)event.getSource();
                Action action = item.getAction();
                InstrumentManagerConnection connection = (InstrumentManagerConnection)action.getValue("InstrumentManagerConnection");
                connection.delete();
            }
        };
        deleteAction.putValue("InstrumentManagerConnection", connection);
        JMenuItem deleteItem = new JMenuItem(deleteAction);
        deleteItem.setMnemonic('I');
        managerMenu.add(deleteItem);
        InstrumentManagerData manager = connection.getInstrumentManager();
        if (manager != null) {
            managerMenu.addSeparator();
            InstrumentableData[] instrumentables = manager.getInstrumentables();
            for (int i = 0; i < instrumentables.length; ++i) {
                InstrumentableData instrumentable = instrumentables[i];
                if (!showAll && !instrumentable.isConfigured()) continue;
                String description = instrumentable.getDescription();
                AbstractAction action = new AbstractAction(description){

                    public void actionPerformed(ActionEvent event) {
                    }
                };
                action.putValue("InstrumentManagerConnection", connection);
                action.putValue("InstrumentableData", instrumentable);
                LargeMenu menu = new LargeMenu(action);
                menu.addMenuListener(new MenuListener(){

                    public void menuSelected(MenuEvent event) {
                        JMenu menu = (JMenu)event.getSource();
                        Action action = menu.getAction();
                        MenuBar.this.rebuildInstrumentableMenu(menu, (InstrumentManagerConnection)action.getValue("InstrumentManagerConnection"), (InstrumentableData)action.getValue("InstrumentableData"));
                    }

                    public void menuDeselected(MenuEvent event) {
                    }

                    public void menuCanceled(MenuEvent event) {
                    }
                });
                managerMenu.add(menu);
            }
        }
    }

    private void rebuildInstrumentableMenu(JMenu instrumentableMenu, InstrumentManagerConnection connection, InstrumentableData instrumentable) {
        instrumentableMenu.removeAll();
        boolean showAll = this.m_showUnconfigured;
        InstrumentableData[] children = instrumentable.getInstrumentables();
        for (int i = 0; i < children.length; ++i) {
            InstrumentableData child = children[i];
            if (!showAll && !child.isConfigured()) continue;
            String description = child.getDescription();
            AbstractAction action = new AbstractAction(description){

                public void actionPerformed(ActionEvent event) {
                }
            };
            action.putValue("InstrumentManagerConnection", connection);
            action.putValue("InstrumentableData", child);
            LargeMenu menu = new LargeMenu(action);
            menu.addMenuListener(new MenuListener(){

                public void menuSelected(MenuEvent event) {
                    JMenu menu = (JMenu)event.getSource();
                    Action action = menu.getAction();
                    MenuBar.this.rebuildInstrumentableMenu(menu, (InstrumentManagerConnection)action.getValue("InstrumentManagerConnection"), (InstrumentableData)action.getValue("InstrumentableData"));
                }

                public void menuDeselected(MenuEvent event) {
                }

                public void menuCanceled(MenuEvent event) {
                }
            });
            instrumentableMenu.add(menu);
        }
        InstrumentData[] instruments = instrumentable.getInstruments();
        for (int i = 0; i < instruments.length; ++i) {
            InstrumentData instrument = instruments[i];
            if (!showAll && !instrument.isConfigured()) continue;
            String description = instrument.getDescription();
            AbstractAction action = new AbstractAction(description){

                public void actionPerformed(ActionEvent event) {
                }
            };
            action.putValue("InstrumentManagerConnection", connection);
            action.putValue("InstrumentableData", instrumentable);
            action.putValue("InstrumentData", instrument);
            LargeMenu menu = new LargeMenu(action);
            menu.addMenuListener(new MenuListener(){

                public void menuSelected(MenuEvent event) {
                    JMenu menu = (JMenu)event.getSource();
                    Action action = menu.getAction();
                    MenuBar.this.rebuildInstrumentMenu(menu, (InstrumentManagerConnection)action.getValue("InstrumentManagerConnection"), (InstrumentableData)action.getValue("InstrumentableData"), (InstrumentData)action.getValue("InstrumentData"));
                }

                public void menuDeselected(MenuEvent event) {
                }

                public void menuCanceled(MenuEvent event) {
                }
            });
            instrumentableMenu.add(menu);
        }
    }

    private void rebuildInstrumentMenu(JMenu instrumentMenu, final InstrumentManagerConnection connection, InstrumentableData instrumentable, final InstrumentData instrument) {
        instrumentMenu.removeAll();
        boolean showAll = this.m_showUnconfigured;
        AbstractAction createAction = new AbstractAction("Create Sample..."){

            public void actionPerformed(ActionEvent event) {
                connection.showCreateSampleDialog(instrument);
            }
        };
        createAction.putValue("InstrumentManagerConnection", connection);
        createAction.putValue("InstrumentableData", instrumentable);
        createAction.putValue("InstrumentData", instrument);
        JMenuItem createItem = new JMenuItem(createAction);
        createItem.setMnemonic('C');
        instrumentMenu.add(createItem);
        InstrumentSampleData[] samples = instrument.getInstrumentSamples();
        if (samples.length > 0) {
            instrumentMenu.addSeparator();
            for (int i = 0; i < samples.length; ++i) {
                final InstrumentSampleData sample = samples[i];
                if (!showAll && !sample.isConfigured()) continue;
                String description = sample.getDescription();
                AbstractAction action = new AbstractAction(description){

                    public void actionPerformed(ActionEvent event) {
                        connection.viewSample(sample.getName());
                    }
                };
                action.putValue("InstrumentManagerConnection", connection);
                action.putValue("InstrumentSampleData", sample);
                JMenuItem item = new JMenuItem(action);
                instrumentMenu.add(item);
            }
        }
    }

    private JMenu buildOptionsMenu() {
        this.m_menuOptions = new LargeMenu("Options");
        this.m_menuOptions.setMnemonic('O');
        this.m_menuOptions.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent event) {
                MenuBar.this.rebuildOptionsMenu();
            }

            public void menuDeselected(MenuEvent event) {
            }

            public void menuCanceled(MenuEvent event) {
            }
        });
        return this.m_menuOptions;
    }

    protected void rebuildOptionsMenu() {
        this.m_menuOptions.removeAll();
        final JCheckBoxMenuItem antialias = new JCheckBoxMenuItem("Antialias", this.m_frame.isAntialias());
        antialias.setMnemonic('a');
        antialias.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.setAntialias(antialias.getState());
            }
        });
        this.m_menuOptions.add(antialias);
    }

    private JMenu buildWindowMenu() {
        this.m_menuWindow = new LargeMenu("Window");
        this.m_menuWindow.setMnemonic('W');
        this.m_menuWindow.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent event) {
                MenuBar.this.rebuildWindowMenu();
            }

            public void menuDeselected(MenuEvent event) {
            }

            public void menuCanceled(MenuEvent event) {
            }
        });
        return this.m_menuWindow;
    }

    protected void rebuildWindowMenu() {
        this.m_menuWindow.removeAll();
        AbstractAction tileFramesAction = new AbstractAction("Tile frames"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.tileFrames();
            }
        };
        JMenuItem tileFrames = new JMenuItem(tileFramesAction);
        tileFrames.setMnemonic('t');
        this.m_menuWindow.add(tileFrames);
        AbstractAction tileFramesVAction = new AbstractAction("Tile frames vertically"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.tileFramesV();
            }
        };
        JMenuItem tileFramesV = new JMenuItem(tileFramesVAction);
        tileFramesV.setMnemonic('v');
        this.m_menuWindow.add(tileFramesV);
        AbstractAction tileFramesHAction = new AbstractAction("Tile frames horizontally"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.tileFramesH();
            }
        };
        JMenuItem tileFramesH = new JMenuItem(tileFramesHAction);
        tileFramesH.setMnemonic('h');
        this.m_menuWindow.add(tileFramesH);
        AbstractAction closeAllAction = new AbstractAction("Close All"){

            public void actionPerformed(ActionEvent event) {
                MenuBar.this.m_frame.closeAllFrames();
            }
        };
        JMenuItem closeAll = new JMenuItem(closeAllAction);
        closeAll.setMnemonic('o');
        this.m_menuWindow.add(closeAll);
        JInternalFrame[] frames = this.m_frame.getDesktopPane().getAllFrames();
        if (frames.length > 0) {
            this.m_menuWindow.addSeparator();
        }
        for (int i = 0; i < frames.length; ++i) {
            String label = i + 1 + " " + frames[i].getTitle();
            AbstractAction action = new AbstractAction(label){

                public void actionPerformed(ActionEvent event) {
                    JMenuItem menu = (JMenuItem)event.getSource();
                    Action action = menu.getAction();
                    JInternalFrame frame = (JInternalFrame)action.getValue("frame");
                    try {
                        if (frame.isIcon()) {
                            frame.setIcon(false);
                        }
                        frame.setSelected(true);
                        MenuBar.this.m_frame.getDesktopPane().moveToFront(frame);
                    }
                    catch (PropertyVetoException e) {
                        // empty catch block
                    }
                }
            };
            action.putValue("frame", frames[i]);
            JMenuItem item = new JMenuItem(action);
            this.m_menuWindow.add(item);
            if (i >= 10) continue;
            item.setMnemonic((char)(49 + i));
        }
    }
}

