/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.instrument.client.InstrumentData;
import org.apache.excalibur.instrument.client.InstrumentSampleData;
import org.apache.excalibur.instrument.client.http.AbstractHTTPElementData;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentManagerConnection;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentSampleData;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentableData;

class HTTPInstrumentData
extends AbstractHTTPElementData
implements InstrumentData {
    private boolean m_registered = false;
    private int m_type;
    private List m_samples = new ArrayList();
    private HTTPInstrumentSampleData[] m_sampleAry;
    private Map m_sampleMap = new HashMap();

    HTTPInstrumentData(HTTPInstrumentableData parent, String name) {
        super((HTTPInstrumentManagerConnection)parent.getConnection(), parent, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Configuration configuration, boolean recurse) throws ConfigurationException {
        HashMap oldSampleMap;
        super.update(configuration);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Updated Instrument '" + this.getName() + "' to version " + this.getStateVersion());
        }
        this.m_registered = configuration.getAttributeAsBoolean("registered");
        this.m_type = configuration.getAttributeAsInteger("type");
        List list = this.m_samples;
        synchronized (list) {
            oldSampleMap = new HashMap(this.m_sampleMap);
        }
        Configuration[] sampleConfs = configuration.getChildren("sample");
        for (int i = 0; i < sampleConfs.length; ++i) {
            HTTPInstrumentSampleData sData;
            Configuration sConf = sampleConfs[i];
            String sName = sConf.getAttribute("name");
            int sStateVersion = sConf.getAttributeAsInteger("state-version");
            List list2 = this.m_samples;
            synchronized (list2) {
                sData = (HTTPInstrumentSampleData)this.m_sampleMap.get(sName);
                if (sData == null) {
                    sData = new HTTPInstrumentSampleData(this, sName);
                    sData.enableLogging(this.getLogger().getChildLogger(sName));
                    this.m_samples.add(sData);
                    this.m_sampleMap.put(sName, sData);
                    this.m_sampleAry = null;
                }
                oldSampleMap.remove(sName);
            }
            if (recurse) {
                sData.update(sConf);
                continue;
            }
            if (sStateVersion == sData.getStateVersion()) continue;
            sData.update();
        }
        if (!oldSampleMap.isEmpty()) {
            List list3 = this.m_samples;
            synchronized (list3) {
                Iterator iter = oldSampleMap.values().iterator();
                while (iter.hasNext()) {
                    HTTPInstrumentSampleData sample = (HTTPInstrumentSampleData)iter.next();
                    this.m_samples.remove(sample);
                    this.m_sampleMap.remove(sample.getName());
                    this.m_sampleAry = null;
                }
            }
        }
    }

    public boolean update() {
        HTTPInstrumentManagerConnection connection = (HTTPInstrumentManagerConnection)this.getConnection();
        Configuration configuration = connection.getState("instrument.xml?packed=true&name=" + this.urlEncode(this.getName()));
        if (configuration != null) {
            try {
                this.update(configuration, false);
                return true;
            }
            catch (ConfigurationException e) {
                this.getLogger().debug("Unable to update.", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isRegistered() {
        return this.m_registered;
    }

    public int getType() {
        return this.m_type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentSampleData[] getInstrumentSamples() {
        InstrumentSampleData[] samples = this.m_sampleAry;
        if (samples == null) {
            List list = this.m_samples;
            synchronized (list) {
                this.m_sampleAry = new HTTPInstrumentSampleData[this.m_samples.size()];
                this.m_samples.toArray(this.m_sampleAry);
                samples = this.m_sampleAry;
            }
        }
        return samples;
    }

    public boolean createInstrumentSample(String description, long interval, int sampleCount, long leaseTime, int sampleType) {
        HTTPInstrumentManagerConnection connection = (HTTPInstrumentManagerConnection)this.getConnection();
        Configuration configuration = connection.getState("create-sample.xml?name=" + this.urlEncode(this.getName()) + "&description=" + this.urlEncode(description) + "&interval=" + interval + "&size=" + sampleCount + "&lease=" + leaseTime + "&type=" + sampleType);
        return configuration != null;
    }
}

