/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.instrument.client.InstrumentData;
import org.apache.excalibur.instrument.client.InstrumentableData;
import org.apache.excalibur.instrument.client.http.AbstractHTTPData;
import org.apache.excalibur.instrument.client.http.AbstractHTTPElementData;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentData;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentManagerConnection;

class HTTPInstrumentableData
extends AbstractHTTPElementData
implements InstrumentableData {
    private boolean m_registered = false;
    private List m_instrumentables = new ArrayList();
    private HTTPInstrumentableData[] m_instrumentableAry;
    private Map m_instrumentableMap = new HashMap();
    private List m_instruments = new ArrayList();
    private HTTPInstrumentData[] m_instrumentAry;
    private Map m_instrumentMap = new HashMap();

    HTTPInstrumentableData(AbstractHTTPData parent, String name) {
        super((HTTPInstrumentManagerConnection)parent.getConnection(), parent, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Configuration configuration, boolean recurse) throws ConfigurationException {
        super.update(configuration);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Updated Instrumentable '" + this.getName() + "' to version " + this.getStateVersion());
        }
        this.m_registered = configuration.getAttributeAsBoolean("registered");
        Configuration[] instrumentableConfs = configuration.getChildren("instrumentable");
        for (int i = 0; i < instrumentableConfs.length; ++i) {
            HTTPInstrumentableData iaData;
            Configuration iaConf = instrumentableConfs[i];
            String iaName = iaConf.getAttribute("name");
            int iaStateVersion = iaConf.getAttributeAsInteger("state-version");
            List list = this.m_instrumentables;
            synchronized (list) {
                iaData = (HTTPInstrumentableData)this.m_instrumentableMap.get(iaName);
                if (iaData == null) {
                    iaData = new HTTPInstrumentableData(this, iaName);
                    iaData.enableLogging(this.getLogger().getChildLogger(iaName));
                    this.m_instrumentables.add(iaData);
                    this.m_instrumentableAry = null;
                    this.m_instrumentableMap.put(iaName, iaData);
                }
            }
            if (recurse) {
                iaData.update(iaConf, recurse);
                continue;
            }
            if (iaStateVersion == iaData.getStateVersion()) continue;
            iaData.update();
        }
        Configuration[] instrumentConfs = configuration.getChildren("instrument");
        for (int i = 0; i < instrumentConfs.length; ++i) {
            HTTPInstrumentData iData;
            Configuration iConf = instrumentConfs[i];
            String iName = iConf.getAttribute("name");
            int iStateVersion = iConf.getAttributeAsInteger("state-version");
            List list = this.m_instruments;
            synchronized (list) {
                iData = (HTTPInstrumentData)this.m_instrumentMap.get(iName);
                if (iData == null) {
                    iData = new HTTPInstrumentData(this, iName);
                    iData.enableLogging(this.getLogger().getChildLogger(iName));
                    this.m_instruments.add(iData);
                    this.m_instrumentAry = null;
                    this.m_instrumentMap.put(iName, iData);
                }
            }
            if (recurse) {
                iData.update(iConf, recurse);
                continue;
            }
            if (iStateVersion == iData.getStateVersion()) continue;
            iData.update();
        }
    }

    public boolean update() {
        HTTPInstrumentManagerConnection connection = (HTTPInstrumentManagerConnection)this.getConnection();
        Configuration configuration = connection.getState("instrumentable.xml?packed=true&name=" + this.urlEncode(this.getName()));
        if (configuration != null) {
            try {
                this.update(configuration, false);
                return true;
            }
            catch (ConfigurationException e) {
                this.getLogger().debug("Unable to update.", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isRegistered() {
        return this.m_registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentableData[] getInstrumentables() {
        InstrumentableData[] instrumentables = this.m_instrumentableAry;
        if (instrumentables == null) {
            List list = this.m_instrumentables;
            synchronized (list) {
                this.m_instrumentableAry = new HTTPInstrumentableData[this.m_instrumentables.size()];
                this.m_instrumentables.toArray(this.m_instrumentableAry);
                instrumentables = this.m_instrumentableAry;
            }
        }
        return instrumentables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentData[] getInstruments() {
        InstrumentData[] instruments = this.m_instrumentAry;
        if (instruments == null) {
            List list = this.m_instruments;
            synchronized (list) {
                this.m_instrumentAry = new HTTPInstrumentData[this.m_instruments.size()];
                this.m_instruments.toArray(this.m_instrumentAry);
                instruments = this.m_instrumentAry;
            }
        }
        return instruments;
    }
}

