/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ZoneMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;

public final class ZoneMeta {
    private static final String[] EMPTY = new String[0];
    private static Map COUNTRY_MAP = null;
    private static Map EQUIV_MAP = null;

    public static synchronized String[] getAvailableIDs(String country) {
        String[] result;
        if (country == null) {
            country = "";
        }
        if (COUNTRY_MAP == null) {
            Set valid = ZoneMeta.getValidIDs();
            TreeSet unused = new TreeSet(valid);
            ArrayList<String> list = new ArrayList<String>();
            COUNTRY_MAP = new TreeMap();
            int i = 0;
            while (i < ZoneMetaData.COUNTRY.length) {
                String[] z = ZoneMetaData.COUNTRY[i];
                list.clear();
                int j = 1;
                while (j < z.length) {
                    if (valid.contains(z[j])) {
                        list.add(z[j]);
                        unused.remove(z[j]);
                    }
                    ++j;
                }
                COUNTRY_MAP.put(z[0], list.toArray(EMPTY));
                ++i;
            }
            if (unused.size() > 0) {
                list.clear();
                list.addAll(Arrays.asList((String[])COUNTRY_MAP.get("")));
                list.addAll(unused);
                Collections.sort(list);
                COUNTRY_MAP.put("", list.toArray(EMPTY));
            }
        }
        if ((result = (String[])COUNTRY_MAP.get(country)) == null) {
            result = EMPTY;
        }
        return result;
    }

    public static synchronized int countEquivalentIDs(String id) {
        String[] result;
        if (EQUIV_MAP == null) {
            ZoneMeta.createEquivMap();
        }
        return (result = (String[])EQUIV_MAP.get(id)) == null ? 0 : result.length;
    }

    public static synchronized String getEquivalentID(String id, int index) {
        String[] a;
        if (EQUIV_MAP == null) {
            ZoneMeta.createEquivMap();
        }
        return (a = (String[])EQUIV_MAP.get(id)) != null && index >= 0 && index < a.length ? a[index] : "";
    }

    private static void createEquivMap() {
        EQUIV_MAP = new TreeMap();
        Set valid = ZoneMeta.getValidIDs();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < ZoneMetaData.EQUIV.length) {
            String[] z = ZoneMetaData.EQUIV[i];
            list.clear();
            int j = 0;
            while (j < z.length) {
                if (valid.contains(z[j])) {
                    list.add(z[j]);
                }
                ++j;
            }
            if (list.size() > 1) {
                String[] a = list.toArray(EMPTY);
                int j2 = 0;
                while (j2 < a.length) {
                    EQUIV_MAP.put(a[j2], a);
                    ++j2;
                }
            }
            ++i;
        }
    }

    private static Set getValidIDs() {
        TreeSet<String> valid = new TreeSet<String>();
        valid.addAll(Arrays.asList(TimeZone.getAvailableIDs()));
        return valid;
    }
}

