/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.security.Provider;
import java.security.Security;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.excalibur.source.impl.HTTPClientSourceFactory;

public class HTTPSClientSourceFactory
extends HTTPClientSourceFactory {
    public static final String SSL_PROVIDER = "provider";
    public static final String SOCKET_FACTORY = "socket-factory";
    public static final String HTTPS = "https";

    public void parameterize(Parameters params) throws ParameterException {
        super.parameterize(params);
        this.setProvider(params);
        this.setSocketFactory(params);
    }

    private void setProvider(Parameters params) throws ParameterException {
        String provider = null;
        try {
            provider = params.getParameter(SSL_PROVIDER);
        }
        catch (ParameterException e) {
            return;
        }
        Security.addProvider((Provider)this.getInstance(provider));
    }

    private void setSocketFactory(Parameters params) throws ParameterException {
        String factoryName = null;
        try {
            factoryName = params.getParameter(SOCKET_FACTORY);
        }
        catch (ParameterException e) {
            return;
        }
        Protocol protocol = new Protocol(HTTPS, (ProtocolSocketFactory)this.getInstance(factoryName), 443);
        Protocol.registerProtocol((String)HTTPS, (Protocol)protocol);
    }

    private Object getInstance(String className) throws ParameterException {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new ParameterException("Unable to instantiate: " + className, (Throwable)e);
        }
    }
}

