/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleSnapshot;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentSampleException;
import org.apache.excalibur.instrument.manager.http.LineChart;
import org.apache.excalibur.instrument.manager.http.server.AbstractHTTPURLHandler;
import org.apache.excalibur.instrument.manager.http.server.HTTPRedirect;
import org.apache.excalibur.instrument.manager.http.server.URLCoder;

public class SampleChartHandler
extends AbstractHTTPURLHandler {
    private DefaultInstrumentManager m_manager;
    private int m_width;
    private int m_height;
    private boolean m_antialias;

    public SampleChartHandler(DefaultInstrumentManager manager, int width, int height, boolean antialias) {
        super("/sample-chart.jpg", "image/jpeg", "UTF-8");
        this.m_manager = manager;
        this.m_width = width;
        this.m_height = height;
        this.m_antialias = antialias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(String path, Map parameters, OutputStream os) throws IOException {
        Graphics2D g;
        String detailFormat;
        String format;
        int hInterval;
        InstrumentSampleDescriptor desc;
        String name = this.getParameter(parameters, "name");
        try {
            desc = this.m_manager.locateInstrumentSampleDescriptor(name);
        }
        catch (NoSuchInstrumentSampleException e) {
            int pos = name.lastIndexOf(46);
            if (pos >= 0) {
                String iName = URLCoder.encode(name.substring(0, pos), "UTF-8");
                throw new HTTPRedirect("instrument.html?name=" + iName);
            }
            throw new HTTPRedirect("instrumentable.html");
        }
        int width = this.getIntegerParameter(parameters, "width", this.m_width);
        width = Math.max(1, Math.min(2048, width));
        int height = this.getIntegerParameter(parameters, "height", this.m_height);
        height = Math.max(1, Math.min(1024, height));
        boolean antialias = this.getBooleanParameter(parameters, "antialias", this.m_antialias);
        InstrumentSampleSnapshot snapshot = desc.getSnapshot();
        long interval = snapshot.getInterval();
        if (interval < 1000L) {
            hInterval = (int)(10000L / interval);
            format = "{3}:{4}:{5}";
            detailFormat = "{1}/{2} {3}:{4}:{5}.{6}";
        } else if (interval < 60000L) {
            hInterval = (int)(60000L / interval);
            format = "{3}:{4}:{5}";
            detailFormat = "{1}/{2} {3}:{4}:{5}";
        } else if (interval < 600000L) {
            hInterval = (int)(600000L / interval);
            format = "{1}/{2} {3}:{4}";
            detailFormat = "{1}/{2} {3}:{4}";
        } else if (interval < 3600000L) {
            hInterval = (int)(3600000L / interval);
            format = "{1}/{2} {3}:{4}";
            detailFormat = "{1}/{2} {3}:{4}";
        } else if (interval < 86400000L) {
            hInterval = (int)(86400000L / interval);
            format = "{1}/{2}";
            detailFormat = "{1}/{2} {3}:{4}";
        } else if (interval < 604800000L) {
            hInterval = (int)(604800000L / interval);
            format = "{0}/{1}/{2}";
            detailFormat = "{0}/{1}/{2}";
        } else {
            hInterval = 10;
            format = "{0}/{1}/{2}";
            detailFormat = "{0}/{1}/{2}";
        }
        LineChart chart = new LineChart(hInterval, interval, format, detailFormat, 20, antialias);
        chart.setValues(snapshot.getSamples(), snapshot.getTime());
        Object imageData = null;
        BufferedImage bi = new BufferedImage(width, height, 1);
        chart.setSize(bi.getWidth(), bi.getHeight());
        try {
            g = bi.createGraphics();
        }
        catch (Throwable t) {
            byte[] noAWTLibs;
            String imageResource = "noawtlibs.jpg";
            BufferedInputStream is = new BufferedInputStream(this.getClass().getResourceAsStream(imageResource));
            try {
                noAWTLibs = new byte[is.available()];
                is.read(noAWTLibs, 0, noAWTLibs.length);
            }
            finally {
                is.close();
            }
            os.write(noAWTLibs);
            return;
        }
        chart.paintComponent(g);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)os);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bi);
        param.setQuality(0.9f, true);
        encoder.encode(bi, param);
    }
}

