/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentSampleException;
import org.apache.excalibur.instrument.manager.http.AbstractXMLHandler;
import org.apache.excalibur.instrument.manager.http.InstrumentManagerHTTPConnector;

public class XMLSampleLeasesHandler
extends AbstractXMLHandler {
    private InstrumentManagerHTTPConnector m_connector;

    public XMLSampleLeasesHandler(DefaultInstrumentManager manager, InstrumentManagerHTTPConnector connector) {
        super("/sample-leases.xml", manager);
        this.m_connector = connector;
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        String[] names = this.getParameters(parameters, "name");
        long[] leases = this.getLongParameters(parameters, "lease", 0L);
        boolean packed = this.getBooleanParameter(parameters, "packed", false);
        if (names.length != leases.length) {
            throw new FileNotFoundException("The number of leases values not equal to the number of names.");
        }
        out.println("<?xml version='1.0' encoding='UTF-8'?>");
        if (names.length > 0) {
            this.outputLine(out, "", packed, "<samples>");
            for (int i = 0; i < names.length; ++i) {
                InstrumentSampleDescriptor desc;
                String name = names[i];
                long lease = leases[i];
                try {
                    desc = this.getInstrumentManager().locateInstrumentSampleDescriptor(name);
                }
                catch (NoSuchInstrumentSampleException e) {
                    desc = null;
                }
                if (desc == null) continue;
                lease = Math.max(1L, Math.min(lease, this.m_connector.getMaxLeasedSampleLease()));
                if (this.getInstrumentManager().getLeaseSampleCount() >= this.m_connector.getMaxLeasedSamples()) {
                    lease = 1L;
                }
                desc.extendLease(lease);
                this.outputSample(out, desc, "  ", packed);
            }
            this.outputLine(out, "", packed, "</samples>");
        } else {
            this.outputLine(out, "", packed, "<samples/>");
        }
    }
}

