/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;

public class RowRecordsAggregate
extends Record {
    int firstrow = -1;
    int lastrow = -1;
    Map records = new TreeMap();
    int size = 0;

    public void insertRow(RowRecord row) {
        this.size += row.getRecordSize();
        this.records.put(row, row);
        if (row.getRowNumber() < this.firstrow || this.firstrow == -1) {
            this.firstrow = row.getRowNumber();
        }
        if (row.getRowNumber() > this.lastrow || this.lastrow == -1) {
            this.lastrow = row.getRowNumber();
        }
    }

    public void removeRow(RowRecord row) {
        this.size -= row.getRecordSize();
        this.records.remove(row);
    }

    public RowRecord getRow(int rownum) {
        RowRecord row = new RowRecord();
        row.setRowNumber((short)rownum);
        return (RowRecord)this.records.get(row);
    }

    public int getPhysicalNumberOfRows() {
        return this.records.size();
    }

    public int getFirstRowNum() {
        return this.firstrow;
    }

    public int getLastRowNum() {
        return this.lastrow;
    }

    public int serialize(int offset, byte[] data) {
        Iterator itr = this.records.values().iterator();
        int pos = offset;
        while (itr.hasNext()) {
            pos += ((Record)itr.next()).serialize(pos, data);
        }
        return pos - offset;
    }

    protected void fillFields(byte[] data, short size, int offset) {
    }

    protected void validateSid(short id) {
    }

    public short getSid() {
        return -1000;
    }

    public int getRecordSize() {
        return this.size;
    }

    public Iterator getIterator() {
        return this.records.values().iterator();
    }

    public Object clone() {
        RowRecordsAggregate rec = new RowRecordsAggregate();
        Iterator rowIter = this.getIterator();
        while (rowIter.hasNext()) {
            RowRecord row = (RowRecord)((RowRecord)rowIter.next()).clone();
            rec.insertRow(row);
        }
        return rec;
    }

    public int findStartOfRowOutlineGroup(int row) {
        RowRecord rowRecord = this.getRow(row);
        short level = rowRecord.getOutlineLevel();
        int currentRow = row;
        while (this.getRow(currentRow) != null) {
            rowRecord = this.getRow(currentRow);
            if (rowRecord.getOutlineLevel() < level) {
                return currentRow + 1;
            }
            --currentRow;
        }
        return currentRow + 1;
    }

    public int findEndOfRowOutlineGroup(int row) {
        int currentRow;
        short level = this.getRow(row).getOutlineLevel();
        for (currentRow = row; currentRow < this.getLastRowNum() && this.getRow(currentRow) != null && this.getRow(currentRow).getOutlineLevel() >= level; ++currentRow) {
        }
        return currentRow - 1;
    }

    public int writeHidden(RowRecord rowRecord, int row, boolean hidden) {
        short level = rowRecord.getOutlineLevel();
        while (rowRecord != null && this.getRow(row).getOutlineLevel() >= level) {
            rowRecord.setZeroHeight(hidden);
            rowRecord = this.getRow(++row);
        }
        return row - 1;
    }

    public void collapseRow(int rowNumber) {
        int startRow = this.findStartOfRowOutlineGroup(rowNumber);
        RowRecord rowRecord = this.getRow(startRow);
        int lastRow = this.writeHidden(rowRecord, startRow, true);
        if (this.getRow(lastRow + 1) != null) {
            this.getRow(lastRow + 1).setColapsed(true);
        } else {
            RowRecord row = RowRecordsAggregate.createRow(lastRow + 1);
            row.setColapsed(true);
            this.insertRow(row);
        }
    }

    public static RowRecord createRow(int row) {
        RowRecord rowrec = new RowRecord();
        rowrec.setRowNumber(row);
        rowrec.setHeight((short)255);
        rowrec.setOptimize((short)0);
        rowrec.setOptionFlags((short)256);
        rowrec.setXFIndex((short)15);
        return rowrec;
    }

    public boolean isRowGroupCollapsed(int row) {
        int collapseRow = this.findEndOfRowOutlineGroup(row) + 1;
        if (this.getRow(collapseRow) == null) {
            return false;
        }
        return this.getRow(collapseRow).getColapsed();
    }

    public void expandRow(int rowNumber) {
        int idx = rowNumber;
        if (idx == -1) {
            return;
        }
        if (!this.isRowGroupCollapsed(idx)) {
            return;
        }
        int startIdx = this.findStartOfRowOutlineGroup(idx);
        RowRecord row = this.getRow(startIdx);
        int endIdx = this.findEndOfRowOutlineGroup(idx);
        if (!this.isRowGroupHiddenByParent(idx)) {
            for (int i = startIdx; i <= endIdx; ++i) {
                if (row.getOutlineLevel() == this.getRow(i).getOutlineLevel()) {
                    this.getRow(i).setZeroHeight(false);
                    continue;
                }
                if (this.isRowGroupCollapsed(i)) continue;
                this.getRow(i).setZeroHeight(false);
            }
        }
        this.getRow(endIdx + 1).setColapsed(false);
    }

    public boolean isRowGroupHiddenByParent(int row) {
        boolean startHidden;
        short startLevel;
        boolean endHidden;
        short endLevel;
        int endOfOutlineGroupIdx = this.findEndOfRowOutlineGroup(row);
        if (this.getRow(endOfOutlineGroupIdx + 1) == null) {
            endLevel = 0;
            endHidden = false;
        } else {
            endLevel = this.getRow(endOfOutlineGroupIdx + 1).getOutlineLevel();
            endHidden = this.getRow(endOfOutlineGroupIdx + 1).getZeroHeight();
        }
        int startOfOutlineGroupIdx = this.findStartOfRowOutlineGroup(row);
        if (startOfOutlineGroupIdx - 1 < 0 || this.getRow(startOfOutlineGroupIdx - 1) == null) {
            startLevel = 0;
            startHidden = false;
        } else {
            startLevel = this.getRow(startOfOutlineGroupIdx - 1).getOutlineLevel();
            startHidden = this.getRow(startOfOutlineGroupIdx - 1).getZeroHeight();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }
}

