/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends FilterInputStream {
    private long buffer = 0L;
    private int bitsLeft = 0;
    private long bufferMarkSave = 0L;
    private int bitsLeftMarkSave = 0;
    private byte[] bufferTmp = new byte[7];

    public BitInputStream(InputStream in) {
        super(in);
    }

    public long readUBits(int n) throws IOException {
        int byteCount = n + 7 - this.bitsLeft >>> 3;
        int bytesRead = super.read(this.bufferTmp, 0, byteCount);
        int pos = 0;
        switch (bytesRead) {
            case 7: {
                this.buffer = this.buffer << 8 | (long)this.bufferTmp[pos++] & 0xFFL;
            }
            case 6: {
                this.buffer = this.buffer << 8 | (long)this.bufferTmp[pos++] & 0xFFL;
            }
            case 5: {
                this.buffer = this.buffer << 8 | (long)this.bufferTmp[pos++] & 0xFFL;
            }
            case 4: {
                this.buffer = this.buffer << 8 | (long)this.bufferTmp[pos++] & 0xFFL;
            }
            case 3: {
                this.buffer = this.buffer << 8 | (long)this.bufferTmp[pos++] & 0xFFL;
            }
            case 2: {
                this.buffer = this.buffer << 8 | (long)this.bufferTmp[pos++] & 0xFFL;
            }
            case 1: {
                this.buffer = this.buffer << 8 | (long)this.bufferTmp[pos++] & 0xFFL;
            }
            case 0: {
                break;
            }
            case -1: {
                bytesRead = 0;
                break;
            }
            default: {
                throw new Error("Ooops. I seem to have read " + bytesRead + " bytes into a 7 byte array without an " + "Exception. Something's definitely " + "fishy here, please debug...");
            }
        }
        this.bitsLeft += bytesRead << 3;
        if (bytesRead != byteCount) {
            throw new EOFException();
        }
        this.bitsLeft -= n;
        long retval = this.buffer >>> this.bitsLeft;
        long mask = 127 >>> 7 - this.bitsLeft;
        this.buffer &= mask;
        return retval;
    }

    public long readSBits(int n) throws IOException {
        return this.signExpand(this.readUBits(n), n);
    }

    private long signExpand(long val, int n) {
        long wrap = 1L << n - 1;
        if (val >= wrap) {
            val -= wrap << 1;
        }
        return val;
    }

    public byte readToByteBoundary() {
        byte retval = (byte)this.buffer;
        this.buffer = 0L;
        this.bitsLeft = 0;
        return retval;
    }

    public int countRemainingBits() {
        return this.bitsLeft;
    }

    public long availableBits() throws IOException {
        return this.available() * 8 + this.bitsLeft;
    }

    public boolean isAtByteBoundary() {
        return this.bitsLeft == 0;
    }

    public int skipToByteBoundary() {
        int count = this.countRemainingBits();
        this.readToByteBoundary();
        return count;
    }

    public int read() throws IOException {
        try {
            return this.bitsLeft == 0 ? super.read() : (int)this.readUBits(8);
        }
        catch (EOFException e) {
            if (this.countRemainingBits() > 0) {
                return this.readToByteBoundary();
            }
            return -1;
        }
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        if (this.bitsLeft == 0) {
            return super.read(buffer, off, len);
        }
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (len < 0 || off < 0 || off + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        int end = off + len;
        int pos = off;
        while (pos < end) {
            int tmp = this.read();
            if (tmp == -1) {
                return pos - off;
            }
            buffer[pos] = (byte)tmp;
            ++pos;
        }
        return len;
    }

    public long skip(long n) throws IOException {
        long CHUNK_SIZE = 0xFFFFFFFFFFFFFFFL;
        long bytesSkipped = 0L;
        while (n > 0xFFFFFFFFFFFFFFFL) {
            long bitsSkipped = this.skipBits(Long.MAX_VALUE);
            if (bitsSkipped != Long.MAX_VALUE) {
                return bytesSkipped + bitsSkipped / 8L;
            }
            n -= 0xFFFFFFFFFFFFFFFL;
            bytesSkipped += 0xFFFFFFFFFFFFFFFL;
        }
        return bytesSkipped += this.skipBits(n * 8L) / 8L;
    }

    public long skipBits(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        int buffered = this.countRemainingBits();
        if (n < (long)buffered) {
            this.readUBits((int)n);
            return n;
        }
        long remaining = n;
        this.skipToByteBoundary();
        remaining -= (long)buffered;
        remaining -= super.skip(remaining / 8L) * 8L;
        try {
            this.readUBits((int)remaining);
            remaining = 0L;
        }
        catch (EOFException e) {
            remaining -= (long)this.countRemainingBits();
            this.skipToByteBoundary();
        }
        catch (IndexOutOfBoundsException e) {
            remaining -= (long)this.countRemainingBits();
            this.skipToByteBoundary();
        }
        return n - remaining;
    }

    public boolean readBit() throws IOException {
        return this.readUBits(1) != 0L;
    }

    public int readUByte() throws IOException {
        return (int)this.readUBits(8);
    }

    public int readUW16MSB() throws IOException {
        return (int)this.readUBits(16);
    }

    public int readUW16LSB() throws IOException {
        return (int)(this.readUBits(8) | this.readUBits(8) << 8);
    }

    public long readUW32MSB() throws IOException {
        return this.readUBits(32);
    }

    public long readUW32LSB() throws IOException {
        return this.readUBits(8) | this.readUBits(8) << 8 | this.readUBits(8) << 16 | this.readUBits(8) << 24;
    }

    public byte readSByte() throws IOException {
        return (byte)this.readSBits(8);
    }

    public short readSW16MSB() throws IOException {
        return (short)this.readSBits(16);
    }

    public short readSW16LSB() throws IOException {
        return (short)this.signExpand(this.readUW16LSB(), 16);
    }

    public int readSW32MSB() throws IOException {
        return (int)this.readSBits(32);
    }

    public int readSW32LSB() throws IOException {
        return (int)this.signExpand(this.readUW32LSB(), 32);
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
        if (this.markSupported()) {
            this.bufferMarkSave = this.buffer;
            this.bitsLeftMarkSave = this.bitsLeft;
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.buffer = this.bufferMarkSave;
        this.bitsLeft = this.bitsLeftMarkSave;
    }
}

