/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFColorRGB;
import de.tivano.flash.swf.common.SWFFormatException;
import java.io.EOFException;
import java.io.IOException;

public class SWFColorRGBA
extends SWFColorRGB {
    private final int ALPHA;

    public SWFColorRGBA(String str) {
        super(str);
        try {
            this.ALPHA = str.length() < 8 ? 255 : Integer.parseInt(str.substring(6, 8), 16);
            if (this.ALPHA < 0) {
                throw new IllegalArgumentException("Not a legal color representation: " + str);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not a legal color representation: " + str);
        }
    }

    public SWFColorRGBA(SWFColorRGB rgb, int alpha) {
        super(rgb);
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Not a legal alpha value: " + alpha);
        }
        this.ALPHA = alpha;
    }

    public SWFColorRGBA(BitInputStream input) throws IOException {
        super(input);
        try {
            this.ALPHA = input.readUByte();
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a color structure");
        }
    }

    public SWFColorRGBA(BitInputStream input, int alpha) throws IOException {
        super(input);
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Not a legal alpha value: " + alpha);
        }
        this.ALPHA = alpha;
    }

    public int getAlpha() {
        return this.ALPHA;
    }

    public boolean hasAlpha() {
        return this.ALPHA != 255;
    }

    public long length() {
        return 32L;
    }

    public void write(BitOutputStream out) throws IOException {
        super.write(out);
        out.write(this.getAlpha());
    }

    public void write(BitOutputStream out, boolean includeAlpha) throws IOException {
        super.write(out);
        if (includeAlpha) {
            out.write(this.getAlpha());
        }
    }

    public String toHexString(boolean withAlpha) {
        if (withAlpha) {
            return this.toHexString() + this.toHex(this.getAlpha());
        }
        return this.toHexString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SWFColorRGBA) {
            SWFColorRGBA other = (SWFColorRGBA)obj;
            return super.equals(obj) && other.getAlpha() == this.getAlpha();
        }
        return false;
    }
}

