/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFShapeRecord;
import java.io.EOFException;
import java.io.IOException;

public class SWFCurvedEdge
extends SWFShapeRecord {
    private final int CONTROL_X;
    private final int CONTROL_Y;
    private final int ANCHOR_X;
    private final int ANCHOR_Y;

    public SWFCurvedEdge(BitInputStream input) throws IOException {
        try {
            int nbits = (int)input.readUBits(4) + 2;
            this.CONTROL_X = (int)input.readSBits(nbits);
            this.CONTROL_Y = (int)input.readSBits(nbits);
            this.ANCHOR_X = (int)input.readSBits(nbits);
            this.ANCHOR_Y = (int)input.readSBits(nbits);
        }
        catch (EOFException e) {
            throw new SWFFormatException("Could not read a complete curved edge record.");
        }
    }

    public int getControlX() {
        return this.CONTROL_X;
    }

    public int getControlY() {
        return this.CONTROL_Y;
    }

    public int getAnchorX() {
        return this.ANCHOR_X;
    }

    public int getAnchorY() {
        return this.ANCHOR_Y;
    }

    public long length() {
        return 6 + 4 * this.getEntryLength();
    }

    private int getEntryLength() {
        int size = Math.max(Math.max(SWFDataTypeBase.minBitsS(this.ANCHOR_X), SWFDataTypeBase.minBitsS(this.ANCHOR_Y)), Math.max(SWFDataTypeBase.minBitsS(this.CONTROL_X), SWFDataTypeBase.minBitsS(this.CONTROL_Y)));
        return size < 2 ? 2 : size;
    }

    public void write(BitOutputStream out) throws IOException {
        out.writeBits(2L, 2);
        int entryLength = this.getEntryLength();
        out.writeBits(entryLength - 2, 4);
        out.writeBits(this.CONTROL_X, entryLength);
        out.writeBits(this.CONTROL_Y, entryLength);
        out.writeBits(this.ANCHOR_X, entryLength);
        out.writeBits(this.ANCHOR_Y, entryLength);
    }
}

