/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataType;
import java.io.IOException;

public abstract class SWFDataTypeBase
implements SWFDataType {
    public abstract long length();

    public abstract void write(BitOutputStream var1) throws IOException;

    protected static int minBitsU(long val) {
        int minBits = 0;
        if ((val & 0xFFFFFFFF00000000L) != 0L) {
            minBits += 32;
            val >>>= 32;
        }
        if ((val & 0xFFFF0000L) != 0L) {
            minBits += 16;
            val >>>= 16;
        }
        if ((val & 0xFF00L) != 0L) {
            minBits += 8;
            val >>>= 8;
        }
        if ((val & 0xF0L) != 0L) {
            minBits += 4;
            val >>>= 4;
        }
        if ((val & 0xCL) != 0L) {
            minBits += 2;
            val >>>= 2;
        }
        if ((val & 2L) != 0L) {
            ++minBits;
            val >>>= 1;
        }
        if ((val & 1L) != 0L) {
            ++minBits;
        }
        return minBits;
    }

    protected static int minBitsS(long val) {
        if (val == 0L) {
            return 0;
        }
        if (val < 0L) {
            val = -val - 1L;
        }
        return SWFDataTypeBase.minBitsU(val) + 1;
    }

    protected static long paddedLength(long length) {
        return length / 8L * 8L + (length % 8L != 0L ? 8L : 0L);
    }

    protected static double fromFixed(long fixed) {
        return (double)fixed / 65535.0;
    }

    protected static long toFixed(double value) {
        return Math.round(value * 65535.0);
    }
}

