/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFont;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFTopLevelDataType;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SWFDefineFontInfo
extends SWFDataTypeBase
implements SWFTopLevelDataType {
    public static final int TAG_TYPE = 13;
    private byte[][] codeTable;
    private int layout = 0;
    private int encoding = 0;
    private String name = null;
    private int fontID;
    private boolean hasWideCodes = false;

    public SWFDefineFontInfo(BitInputStream input, int glyphCount) throws IOException {
        this(input, glyphCount, input.readUW16LSB());
    }

    public SWFDefineFontInfo(BitInputStream input, int glyphCount, int fontID) throws IOException {
        try {
            this.fontID = fontID;
            byte[] nameRaw = new byte[input.readUByte()];
            input.read(nameRaw);
            input.skipBits(2L);
            int encodingRaw = (int)input.readUBits(3);
            if (input.readBit()) {
                this.layout |= 2;
            }
            if (input.readBit()) {
                this.layout |= 1;
            }
            this.hasWideCodes = input.readBit();
            switch (encodingRaw) {
                case 0: {
                    this.encoding = this.hasWideCodes ? 3 : 1;
                    break;
                }
                case 1: {
                    this.encoding = 2;
                    break;
                }
                case 2: {
                    this.encoding = 1;
                    break;
                }
                case 4: {
                    this.encoding = 3;
                    break;
                }
                default: {
                    throw new SWFFormatException("Illegal combination of font encoding flags encountered: " + encodingRaw);
                }
            }
            this.name = new String(nameRaw, SWFFont.getCanonicalEncodingName(this.encoding));
            this.codeTable = new byte[glyphCount][this.hasWideCodes ? 2 : 1];
            int i = 0;
            while (i < this.codeTable.length) {
                if (this.hasWideCodes) {
                    this.codeTable[i][1] = (byte)input.read();
                }
                this.codeTable[i][0] = (byte)input.read();
                ++i;
            }
            if (this.encoding == 2) {
                int i2 = 0;
                while (i2 < this.codeTable.length) {
                    if (this.codeTable[i2][0] == 0) {
                        byte[] newCode = new byte[]{this.codeTable[i2][1]};
                        this.codeTable[i2] = newCode;
                    }
                    ++i2;
                }
            }
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a DefineFont2 tag");
        }
    }

    public SWFDefineFontInfo(SWFFont font) throws UnsupportedEncodingException {
        this.fontID = font.getFontID();
        this.name = font.getFontName();
        this.encoding = font.getEncoding();
        this.layout = font.getLayout();
        this.codeTable = new byte[font.glyphCount()][];
        this.hasWideCodes = false;
        int i = 0;
        while (i < this.codeTable.length) {
            this.codeTable[i] = font.encode(font.getCharCode(i));
            this.hasWideCodes |= this.codeTable[i].length > 1;
            ++i;
        }
    }

    public int getEncoding() {
        return this.encoding;
    }

    public int getLayout() {
        return this.layout;
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.fontID;
    }

    public int getGlyphCount() {
        return this.codeTable.length;
    }

    public byte[] getCode(int idx) {
        return this.codeTable[idx];
    }

    public long length() {
        return 32 + this.getCharWidth() * this.getGlyphCount() + 8 * this.getName().length();
    }

    private int getCharWidth() {
        return this.hasWideCodes ? 16 : 8;
    }

    public void write(BitOutputStream out) throws IOException {
        int glyphCount = this.getGlyphCount();
        out.writeW16LSB(this.getID());
        byte[] nameRaw = this.getName().getBytes("US-ASCII");
        if (nameRaw.length > 255) {
            throw new IllegalStateException("Font name longer than 255 bytes found. This should never happen. Please debug.");
        }
        out.write(nameRaw.length);
        out.write(nameRaw);
        out.writeBits(0L, 2);
        switch (this.getEncoding()) {
            case 2: {
                out.writeBits(1L, 3);
                break;
            }
            case 1: {
                out.writeBits(2L, 3);
                break;
            }
            case 3: {
                out.writeBits(4L, 3);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal encoding value " + this.getEncoding() + " found. This should never happen. Please debug.");
            }
        }
        out.writeBit((this.getLayout() & 2) != 0);
        out.writeBit((this.getLayout() & 1) != 0);
        out.writeBit(this.hasWideCodes);
        int i = 0;
        while (i < glyphCount) {
            byte[] code = this.getCode(i);
            if (this.hasWideCodes && code.length == 1) {
                out.write(0);
            }
            out.write(code);
            ++i;
        }
    }

    public int getTagType() {
        return 13;
    }
}

