/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFGradientRecord;
import de.tivano.flash.swf.common.SWFSolidGradientRecord;
import de.tivano.flash.swf.common.SWFTransparentGradientRecord;
import java.io.EOFException;
import java.io.IOException;

public class SWFGradient
extends SWFDataTypeBase {
    private final SWFGradientRecord[] GRADIENT_RECORDS;

    public int getRecordCount() {
        return this.GRADIENT_RECORDS.length;
    }

    public boolean hasAlpha() {
        return this.GRADIENT_RECORDS[0].hasAlpha();
    }

    public SWFGradientRecord getRecord(int idx) {
        return this.GRADIENT_RECORDS[idx];
    }

    public SWFGradient(BitInputStream input, boolean useRGBA) throws IOException {
        try {
            int count = input.readUByte();
            if (count < 1) {
                throw new SWFFormatException("Found a gradient record count of " + count + ". Expected at least one gradient record.");
            }
            this.GRADIENT_RECORDS = new SWFGradientRecord[count];
            int i = 0;
            while (i < count) {
                this.GRADIENT_RECORDS[i] = SWFGradientRecord.parse(input, useRGBA);
                ++i;
            }
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a gradient structure");
        }
    }

    public SWFGradient(SWFSolidGradientRecord[] records) {
        if (records.length == 0) {
            throw new IllegalArgumentException("Expected at least one gradient record");
        }
        this.GRADIENT_RECORDS = new SWFGradientRecord[records.length];
        int i = 0;
        while (i < records.length) {
            if (records[i] == null) {
                throw new NullPointerException("records[" + i + "] may not be null");
            }
            this.GRADIENT_RECORDS[i] = records[i];
            ++i;
        }
    }

    public SWFGradient(SWFTransparentGradientRecord[] records) {
        if (records.length == 0) {
            throw new IllegalArgumentException("Expected at least one gradient record");
        }
        this.GRADIENT_RECORDS = new SWFGradientRecord[records.length];
        int i = 0;
        while (i < records.length) {
            if (records[i] == null) {
                throw new NullPointerException("records[" + i + "] may not be null");
            }
            this.GRADIENT_RECORDS[i] = records[i];
            ++i;
        }
    }

    public void write(BitOutputStream out) throws IOException {
        out.writeBits(this.GRADIENT_RECORDS.length, 8);
        int i = 0;
        while (i < this.GRADIENT_RECORDS.length) {
            this.GRADIENT_RECORDS[i].write(out);
            ++i;
        }
    }

    public long length() {
        long length = 8L;
        if (this.GRADIENT_RECORDS.length > 0) {
            length += (long)this.GRADIENT_RECORDS.length * this.GRADIENT_RECORDS[0].length();
        }
        return length;
    }
}

