/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFormatException;
import java.io.EOFException;
import java.io.IOException;

public class SWFMoveTo
extends SWFDataTypeBase {
    private final int X;
    private final int Y;

    public SWFMoveTo(BitInputStream input) throws IOException {
        try {
            int nbits = (int)input.readUBits(5);
            this.X = (int)input.readSBits(nbits);
            this.Y = (int)input.readSBits(nbits);
        }
        catch (EOFException e) {
            throw new SWFFormatException("Could not read a complete 'move to' state change record.");
        }
    }

    public int getX() {
        return this.X;
    }

    public int getY() {
        return this.Y;
    }

    public long length() {
        return 5 + 2 * this.getEntryLength();
    }

    private int getEntryLength() {
        return Math.max(SWFDataTypeBase.minBitsS(this.getX()), SWFDataTypeBase.minBitsS(this.getY()));
    }

    public void write(BitOutputStream out) throws IOException {
        int entryLength = this.getEntryLength();
        out.writeBits(entryLength, 5);
        out.writeBits(this.getX(), entryLength);
        out.writeBits(this.getY(), entryLength);
    }
}

