/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFShapeRecord;
import java.io.EOFException;
import java.io.IOException;

public class SWFStraightEdge
extends SWFShapeRecord {
    private final int DELTA_X;
    private final int DELTA_Y;

    public SWFStraightEdge(BitInputStream input) throws IOException {
        try {
            int nbits = (int)input.readUBits(4) + 2;
            if (input.readBit()) {
                this.DELTA_X = (int)input.readSBits(nbits);
                this.DELTA_Y = (int)input.readSBits(nbits);
            } else if (input.readBit()) {
                this.DELTA_X = 0;
                this.DELTA_Y = (int)input.readSBits(nbits);
            } else {
                this.DELTA_X = (int)input.readSBits(nbits);
                this.DELTA_Y = 0;
            }
        }
        catch (EOFException e) {
            throw new SWFFormatException("Could not read a complete straight edge record.");
        }
    }

    public int getX() {
        return this.DELTA_X;
    }

    public int getY() {
        return this.DELTA_Y;
    }

    public boolean isHorizontal() {
        return this.DELTA_Y == 0;
    }

    public boolean isVertical() {
        return this.DELTA_X == 0;
    }

    public long length() {
        if (this.isHorizontal() || this.isVertical()) {
            return 8 + this.getEntryLength();
        }
        return 7 + 2 * this.getEntryLength();
    }

    private int getEntryLength() {
        int size = Math.max(SWFDataTypeBase.minBitsS(this.getX()), SWFDataTypeBase.minBitsS(this.getY()));
        return size < 2 ? 2 : size;
    }

    public void write(BitOutputStream out) throws IOException {
        int entryLength = this.getEntryLength();
        out.writeBits(3L, 2);
        out.writeBits(entryLength - 2, 4);
        if (this.isHorizontal()) {
            out.writeBits(0L, 2);
            out.writeBits(this.getX(), entryLength);
        } else if (this.isVertical()) {
            out.writeBits(1L, 2);
            out.writeBits(this.getY(), entryLength);
        } else {
            out.writeBits(1L, 1);
            out.writeBits(this.getX(), entryLength);
            out.writeBits(this.getY(), entryLength);
        }
    }
}

