/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.parser;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.SWFDefineFontInfo;
import de.tivano.flash.swf.common.SWFFont;
import de.tivano.flash.swf.common.SWFTagHeader;
import de.tivano.flash.swf.parser.SWFAttributes;
import de.tivano.flash.swf.parser.SWFTagReaderBase;
import java.io.IOException;
import org.xml.sax.SAXException;

public class SWFDefineFontInfoReader
extends SWFTagReaderBase {
    public void parse(BitInputStream input, SWFTagHeader header) throws SAXException, IOException {
        SWFFont font = null;
        int fontInfoID = input.readUW16LSB();
        try {
            font = (SWFFont)this.getContextMap().get(new Integer(fontInfoID));
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (font == null) {
            this.fatalError("No font with ID " + fontInfoID + " found in context map.");
            return;
        }
        SWFDefineFontInfo fontInfo = new SWFDefineFontInfo(input, font.glyphCount(), fontInfoID);
        SWFAttributes attrib = this.createAttributes();
        String style = null;
        switch (fontInfo.getLayout()) {
            case 1: {
                style = "bold";
                break;
            }
            case 2: {
                style = "italic";
                break;
            }
            case 3: {
                style = "bold-italic";
            }
        }
        String encoding = null;
        switch (fontInfo.getEncoding()) {
            case 3: {
                encoding = "unicode";
                break;
            }
            case 2: {
                encoding = "shift-jis";
            }
        }
        font.setEncoding(fontInfo.getEncoding());
        font.setFontName(fontInfo.getName());
        attrib.addAttribute("id", fontInfoID, "ID");
        attrib.addAttribute("name", fontInfo.getName());
        if (style != null) {
            attrib.addAttribute("style", style);
        }
        if (encoding != null) {
            attrib.addAttribute("encoding", encoding);
        }
        this.startElement("Font", attrib);
        int i = 0;
        while (i < fontInfo.getGlyphCount()) {
            String charcode = font.decode(fontInfo.getCode(i));
            font.setCharCode(i, charcode);
            attrib.clear();
            attrib.addAttribute("char", charcode);
            this.emptyElement("Glyph", attrib);
            ++i;
        }
        this.endElement("Font");
    }
}

