/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.parser;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.SWFDefineFont;
import de.tivano.flash.swf.common.SWFDefineFontInfo;
import de.tivano.flash.swf.common.SWFFont;
import de.tivano.flash.swf.common.SWFTagHeader;
import de.tivano.flash.swf.parser.SWFAttributes;
import de.tivano.flash.swf.parser.SWFRawShapeReader;
import de.tivano.flash.swf.parser.SWFReader;
import de.tivano.flash.swf.parser.SWFShapeReader;
import de.tivano.flash.swf.parser.SWFTagReaderBase;
import java.io.IOException;
import org.xml.sax.SAXException;

public class SWFDefineFontReader
extends SWFTagReaderBase {
    protected SWFShapeReader shapeReader = new SWFRawShapeReader(false);

    public void setSAXDriver(SWFReader driver) {
        super.setSAXDriver(driver);
        this.shapeReader.setSAXDriver(driver);
    }

    public void parse(BitInputStream input, SWFTagHeader header) throws SAXException, IOException {
        SWFDefineFont fontTag = new SWFDefineFont(input);
        SWFDefineFontInfo fontInfo = null;
        SWFFont font = new SWFFont();
        font.setFontID(fontTag.getID());
        this.getContextMap().put(new Integer(fontTag.getID()), font);
        input.mark(8);
        SWFTagHeader nextHeader = new SWFTagHeader(input);
        SWFAttributes attrib = this.createAttributes();
        int fontInfoID = -1;
        if (nextHeader.getID() == 13) {
            fontInfoID = input.readUW16LSB();
        }
        if (fontInfoID == fontTag.getID()) {
            fontInfo = new SWFDefineFontInfo(input, fontTag.getGlyphCount(), fontInfoID);
            String style = null;
            switch (fontInfo.getLayout()) {
                case 1: {
                    style = "bold";
                    break;
                }
                case 2: {
                    style = "italic";
                    break;
                }
                case 3: {
                    style = "bold-italic";
                }
            }
            String encoding = null;
            switch (fontInfo.getEncoding()) {
                case 3: {
                    encoding = "unicode";
                    break;
                }
                case 2: {
                    encoding = "shift-jis";
                }
            }
            font.setEncoding(fontInfo.getEncoding());
            font.setFontName(fontInfo.getName());
            attrib.addAttribute("id", fontInfoID, "ID");
            attrib.addAttribute("name", fontInfo.getName());
            if (style != null) {
                attrib.addAttribute("style", style);
            }
            if (encoding != null) {
                attrib.addAttribute("encoding", encoding);
            }
            this.startElement("Font", attrib);
            int i = 0;
            while (i < fontTag.getGlyphCount()) {
                String charcode = font.decode(fontInfo.getCode(i));
                font.addGlyph(charcode, true);
                attrib.clear();
                attrib.addAttribute("char", charcode);
                this.startElement("Glyph", attrib);
                this.shapeReader.toXML(fontTag.getShape(i));
                this.endElement("Glyph");
                ++i;
            }
            this.endElement("Font");
        } else {
            input.reset();
            attrib.addAttribute("id", fontTag.getID(), "ID");
            this.startElement("FontOutlines", attrib);
            int i = 0;
            while (i < fontTag.getGlyphCount()) {
                font.addGlyph();
                this.shapeReader.toXML(fontTag.getShape(i));
                ++i;
            }
            this.endElement("FontOutlines");
        }
    }
}

