/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.parser;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.SWFColorRGBA;
import de.tivano.flash.swf.common.SWFDefineTextField;
import de.tivano.flash.swf.common.SWFFont;
import de.tivano.flash.swf.common.SWFRectangle;
import de.tivano.flash.swf.common.SWFTagHeader;
import de.tivano.flash.swf.parser.SWFAttributes;
import de.tivano.flash.swf.parser.SWFTagReaderBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;

public class SWFDefineTextFieldReader
extends SWFTagReaderBase {
    private static final Map ENTITIES = new HashMap();
    private static final char[] UNKNOWN_ENTITY;
    private SWFAttributes pAttr = this.createAttributes();
    private SWFAttributes fontAttr = this.createAttributes();
    private SWFAttributes htmlAttr = this.createAttributes();
    SWFAttributes attrib = this.createAttributes();

    public void parse(BitInputStream input, SWFTagHeader header) throws SAXException, IOException {
        SWFDefineTextField textField = new SWFDefineTextField(input);
        String encoding = SWFFont.getCanonicalEncodingName(1);
        SWFFont font = null;
        this.attrib.clear();
        if (textField.hasFont()) {
            font = (SWFFont)this.getContextMap().get(new Integer(textField.getFontID()));
            if (font != null) {
                encoding = font.getCanonicalEncodingName();
            } else {
                this.error("No context information for font " + textField.getFontID() + ". Reverting to " + encoding + " encoding for this text.");
            }
        } else {
            this.warning("Text field with no associated font found. Assuming " + encoding + " encoding for this text.");
        }
        this.attrib.addAttribute("id", textField.getID());
        if (textField.getVarName() != null) {
            this.attrib.addAttribute("name", textField.getVarName());
        }
        if (!textField.isReadonly()) {
            if (textField.isMultiline()) {
                this.attrib.addAttribute("multiline", "yes");
            }
            if (textField.isPassword()) {
                this.attrib.addAttribute("password", "yes");
            }
            if (textField.useWordWrap()) {
                this.attrib.addAttribute("wordwrap", "yes");
            }
            if (textField.getMaxLength() != -1) {
                this.attrib.addAttribute("maxlength", textField.getMaxLength());
            }
            this.startElement("TextInput", this.attrib);
            this.attrib.clear();
        }
        SWFRectangle bounds = textField.getBounds();
        SWFColorRGBA color = textField.getTextColor();
        this.attrib.addAttribute("xmin", bounds.getXMin());
        this.attrib.addAttribute("xmax", bounds.getXMax());
        this.attrib.addAttribute("ymin", bounds.getYMin());
        this.attrib.addAttribute("ymax", bounds.getYMax());
        if (textField.hasBorder()) {
            this.attrib.addAttribute("border", "yes");
        }
        if (textField.isSelectable()) {
            this.attrib.addAttribute("selectable", "yes");
        }
        if (color.getAlpha() != 255) {
            this.attrib.addAttribute("alpha", "#" + Integer.toString(color.getAlpha(), 16));
        }
        if (textField.hasLayout()) {
            this.attrib.addAttribute("leftmargin", this.fromTwips(textField.getLeftMargin()));
            this.attrib.addAttribute("rightmargin", this.fromTwips(textField.getRightMargin()));
            this.attrib.addAttribute("indent", this.fromTwips(textField.getTextIndent()));
            this.attrib.addAttribute("linespacing", this.fromTwips(textField.getLineSpacing()));
        }
        this.startElement("Text", this.attrib);
        char[] text = new String(textField.getText(), encoding).toCharArray();
        if (textField.isHTML()) {
            this.handleHTMLText(text);
        } else {
            String fontName = null;
            int fontLayout = 0;
            int fontSize = 12;
            if (font != null) {
                fontName = font.getFontName();
                fontLayout = font.getLayout();
            }
            this.handlePlainText(text, textField.getTextAlign(), fontName, fontLayout, this.fromTwips(textField.getFontHeight()), color);
        }
        this.endElement("Text");
        if (!textField.isReadonly()) {
            this.endElement("TextInput");
        }
    }

    protected void handlePlainText(char[] text, int align, String font, int layout, double size, SWFColorRGBA color) throws SAXException {
        int start;
        this.pAttr.clear();
        this.fontAttr.clear();
        switch (align) {
            case 0: {
                this.pAttr.addAttribute("ALIGN", "LEFT");
                break;
            }
            case 1: {
                this.pAttr.addAttribute("ALIGN", "RIGHT");
                break;
            }
            case 2: {
                this.pAttr.addAttribute("ALIGN", "CENTER");
                break;
            }
            case 3: {
                this.pAttr.addAttribute("ALIGN", "JUSTIFY");
                break;
            }
            default: {
                this.warning("Unknown text alignment. Defaulting to \"LEFT\"");
                this.pAttr.addAttribute("ALIGN", "LEFT");
            }
        }
        if (font != null) {
            this.fontAttr.addAttribute("FACE", font);
        }
        this.fontAttr.addAttribute("SIZE", size);
        this.fontAttr.addAttribute("COLOR", "#" + color.toHexString(false).toUpperCase());
        int end = start = 0;
        do {
            this.startElement("P", this.pAttr);
            while (end < text.length && text[end] != '\r') {
                ++end;
            }
            if (start < ++end) {
                this.startElement("FONT", this.fontAttr);
                if ((layout & 1) != 0) {
                    this.startElement("B", null);
                }
                if ((layout & 2) != 0) {
                    this.startElement("I", null);
                }
                this.handleGeneratorVariables(text, start, end - 1);
                if ((layout & 2) != 0) {
                    this.endElement("I");
                }
                if ((layout & 1) != 0) {
                    this.endElement("B");
                }
                this.endElement("FONT");
            }
            this.endElement("P");
            start = end;
        } while (end < text.length);
    }

    protected void handleHTMLText(char[] text) throws SAXException {
        int start;
        int pos = start = 0;
        while (pos < text.length) {
            switch (text[pos]) {
                case '<': {
                    this.handleGeneratorVariables(text, start, pos);
                    pos = start = this.handleHTMLTag(text, pos) + 1;
                    break;
                }
                case '&': {
                    this.handleGeneratorVariables(text, start, pos++);
                    int end = pos;
                    try {
                        while (text[end] != ';') {
                            ++end;
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.warning("Unescaped '&' found.");
                        start = pos - 1;
                        break;
                    }
                    char[] entity = (char[])ENTITIES.get(new String(text, pos, end - pos));
                    if (entity == null) {
                        this.warning("Unknow character entity &" + new String(text, pos, end - pos - 1) + "; found. Substituting " + UNKNOWN_ENTITY);
                        entity = UNKNOWN_ENTITY;
                    }
                    this.characters(entity, 0, entity.length);
                    pos = start = end + 1;
                    break;
                }
                default: {
                    ++pos;
                }
            }
        }
        this.handleGeneratorVariables(text, start, pos);
    }

    /*
     * Unable to fully structure code
     */
    protected int handleHTMLTag(char[] buffer, int start) throws SAXException {
        end = pos = start + 1;
        try {
            if (buffer[pos] == '/') {
                ++pos;
                while (buffer[end] != '>') {
                    ++end;
                }
                this.endElement(new String(buffer, pos, end - pos));
                return end;
            }
            this.htmlAttr.clear();
            while (buffer[end] != ' ' && buffer[end] != '>') {
                ++end;
            }
            tagName = new String(buffer, pos, end - pos);
            pos = end;
            while (buffer[pos] == ' ') {
                ++pos;
            }
            end = pos;
            ** GOTO lbl36
            {
                ++end;
                do {
                    if (buffer[end] != '=') continue block5;
                    attName = new String(buffer, pos, end - pos);
                    pos = end += 2;
                    while (buffer[end] != '\"') {
                        ++end;
                    }
                    attValue = new String(buffer, pos, end - pos);
                    this.htmlAttr.addAttribute(attName, attValue);
                    pos = ++end;
                    while (buffer[pos] == ' ') {
                        ++pos;
                    }
                    end = pos;
lbl36:
                    // 2 sources

                } while (buffer[end] != '>');
            }
            this.startElement(tagName, this.htmlAttr);
            return end;
        }
        catch (IndexOutOfBoundsException e) {
            this.warning("Illegal syntax for embedded HTML tag: \"" + new String(buffer, start, buffer.length - start) + "\". Assuming unescaped '<'.");
            return start - 1;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void handleGeneratorVariables(char[] buffer, int start, int end) throws SAXException {
        attrib = this.createAttributes();
        pos = start;
        ** GOTO lbl24
        {
            ++pos;
            do {
                if (pos < end && buffer[pos] != '{') continue block0;
                if (pos != start) {
                    this.characters(buffer, start, pos - start);
                }
                start = pos + 1;
                if (pos >= end) continue;
                while (pos < end && buffer[pos] != '}') {
                    ++pos;
                }
                if (buffer[pos] != '}') {
                    this.warning("Unmatched \"{\" found. Skipping generator variable.");
                    this.characters(buffer, start, pos - start);
                } else {
                    attrib.clear();
                    attrib.addAttribute("ID", new String(buffer, start, pos - start));
                    this.startElement("SPAN", attrib);
                    this.characters(buffer, start - 1, pos - start + 2);
                    this.endElement("SPAN");
                }
                start = pos + 1;
lbl24:
                // 3 sources

            } while (start < end);
        }
    }

    static {
        ENTITIES.put("nbsp", new char[]{'\u00a0'});
        ENTITIES.put("lt", new char[]{'<'});
        ENTITIES.put("gt", new char[]{'>'});
        ENTITIES.put("amp", new char[]{'&'});
        ENTITIES.put("quot", new char[]{'\"'});
        UNKNOWN_ENTITY = new char[]{'\u25af'};
    }
}

