/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.publisher;

import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataType;
import de.tivano.flash.swf.common.SWFDefineFont;
import de.tivano.flash.swf.common.SWFDefineFont2;
import de.tivano.flash.swf.common.SWFDefineFontInfo;
import de.tivano.flash.swf.common.SWFFont;
import de.tivano.flash.swf.common.SWFTagHeader;
import de.tivano.flash.swf.publisher.SWFTagWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SWFFontWriter
extends SWFTagWriter {
    private SWFFont font;
    SWFDataType fontWriter = null;

    public SWFFontWriter(SWFFont font) {
        this.font = font;
    }

    protected long getDataLength() {
        return this.fontWriter.length() / 8L;
    }

    protected void initWriteData() throws IOException {
        if (this.font.hasMetrics()) {
            this.fontWriter = new SWFDefineFont2(this.font);
            this.HEADER.setID(48);
        } else {
            this.fontWriter = new DefineFontPair(this.font);
            this.HEADER.setID(10);
        }
        this.font = null;
    }

    public void writeData(BitOutputStream out) throws IOException {
        this.fontWriter.write(out);
    }

    public long getTotalLength() throws IOException {
        this.doInitDataLength();
        long dataLength = this.getDataLength();
        if (this.fontWriter instanceof DefineFontPair) {
            this.HEADER.setRecordLength(((DefineFontPair)this.fontWriter).fontLength() / 8L);
        } else {
            this.HEADER.setRecordLength(dataLength);
        }
        return dataLength + this.HEADER.length() / 8L;
    }

    public void write(BitOutputStream out) throws IOException {
        this.doInitWriteData();
        if (this.fontWriter instanceof DefineFontPair) {
            this.HEADER.setRecordLength(((DefineFontPair)this.fontWriter).fontLength() / 8L);
        } else {
            this.HEADER.setRecordLength(this.getDataLength());
        }
        this.HEADER.write(out);
        this.writeData(out);
    }

    private static class DefineFontPair
    implements SWFDataType {
        private SWFDefineFont font;
        private SWFTagHeader fontInfoHeader = new SWFTagHeader(13);
        private SWFDefineFontInfo fontInfo;

        public DefineFontPair(SWFFont fontDef) throws UnsupportedEncodingException {
            this.font = new SWFDefineFont(fontDef);
            this.fontInfo = new SWFDefineFontInfo(fontDef);
        }

        public long length() {
            long infoLength = this.fontInfo.length();
            this.fontInfoHeader.setRecordLength(infoLength / 8L);
            return infoLength + this.fontInfoHeader.length() + this.font.length();
        }

        public long fontLength() {
            return this.font.length();
        }

        public void write(BitOutputStream out) throws IOException {
            this.font.write(out);
            this.fontInfoHeader.setRecordLength(this.fontInfo.length() / 8L);
            this.fontInfoHeader.write(out);
            this.fontInfo.write(out);
        }
    }
}

