/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfPhrase
extends RtfElement {
    public static final byte[] PARAGRAPH_DEFAULTS = "\\pard".getBytes();
    protected static final byte[] IN_TABLE = "\\intbl".getBytes();
    protected ArrayList chunks = new ArrayList();

    public RtfPhrase(RtfDocument rtfDocument, Phrase phrase) {
        super(rtfDocument);
        if (phrase == null) {
            return;
        }
        ArrayList arrayList = phrase.getChunks();
        for (int i = 0; i < arrayList.size(); ++i) {
            Chunk chunk = (Chunk)arrayList.get(i);
            chunk.setFont(phrase.font().difference(chunk.font()));
            try {
                this.chunks.add(rtfDocument.getMapper().mapElement(chunk));
                continue;
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                byteArrayOutputStream.write(IN_TABLE);
            }
            for (int i = 0; i < this.chunks.size(); ++i) {
                byteArrayOutputStream.write(((RtfBasicElement)this.chunks.get(i)).write());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setInTable(boolean bl) {
        super.setInTable(bl);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setInTable(bl);
        }
    }

    public void setInHeader(boolean bl) {
        super.setInHeader(bl);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setInHeader(bl);
        }
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        super.setRtfDocument(rtfDocument);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setRtfDocument(this.document);
        }
    }
}

