/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pluto.core.InternalPortletResponse;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.InformationProviderAccess;
import org.apache.pluto.services.information.ResourceURLProvider;
import org.apache.pluto.services.property.PropertyManager;
import org.apache.pluto.util.PrintWriterServletOutputStream;

public abstract class PortletResponseImpl
extends HttpServletResponseWrapper
implements InternalPortletResponse,
PortletResponse {
    PortletWindow portletWindow;
    private HttpServletRequest webModuleServletRequest;
    private boolean usingWriter;
    private boolean usingStream;
    private ServletOutputStream wrappedWriter;
    private Map properties;
    private boolean included;

    public PortletResponseImpl(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        super(servletResponse);
        this.webModuleServletRequest = servletRequest;
        this.portletWindow = portletWindow;
    }

    public void addProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Property key == null");
        }
        Map props = this.getProperties();
        String[] oldValues = (String[])props.get(key);
        String[] newValues = null;
        if (oldValues == null) {
            newValues = new String[]{value};
        } else {
            int len = oldValues.length;
            newValues = new String[len + 1];
            System.arraycopy(oldValues, 0, newValues, 0, len);
            newValues[len] = value;
        }
        props.put(key, newValues);
        PropertyManager.setResponseProperties(this.portletWindow, this.getHttpServletRequest(), this._getHttpServletResponse(), props);
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Property key == null");
        }
        Map props = this.getProperties();
        String[] newValues = new String[]{value};
        props.put(key, newValues);
        PropertyManager.setResponseProperties(this.portletWindow, this.getHttpServletRequest(), this._getHttpServletResponse(), props);
    }

    public String encodeURL(String path) {
        if (path.indexOf("://") == -1 && !path.startsWith("/")) {
            throw new IllegalArgumentException("only absolute URLs or full path URIs are allowed");
        }
        ResourceURLProvider provider = InformationProviderAccess.getDynamicProvider(this.getHttpServletRequest()).getResourceURLProvider(this.portletWindow);
        if (path.indexOf("://") != -1) {
            provider.setAbsoluteURL(path);
        } else {
            provider.setFullPath(path);
        }
        return this._getHttpServletResponse().encodeURL(((Object)provider).toString());
    }

    public void lateInit(HttpServletRequest webModuleServletRequest, HttpServletResponse webModuleServletResponse) {
        this.webModuleServletRequest = webModuleServletRequest;
        this.setResponse((ServletResponse)webModuleServletResponse);
    }

    protected HttpServletResponse _getHttpServletResponse() {
        return (HttpServletResponse)super.getResponse();
    }

    protected HttpServletRequest getHttpServletRequest() {
        return this.webModuleServletRequest;
    }

    private Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public void addCookie(Cookie cookie) {
        this._getHttpServletResponse().addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this._getHttpServletResponse().containsHeader(name);
    }

    public String encodeRedirectUrl(String url) {
        return this.included ? null : this._getHttpServletResponse().encodeRedirectUrl(url);
    }

    public String encodeRedirectURL(String url) {
        return this.included ? null : this._getHttpServletResponse().encodeRedirectURL(url);
    }

    public void sendRedirect(String location) throws IOException {
        this._getHttpServletResponse().sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        this._getHttpServletResponse().setDateHeader(name, date);
    }

    public void sendError(int sc, String msg) throws IOException {
        this._getHttpServletResponse().sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this._getHttpServletResponse().sendError(sc);
    }

    public void addHeader(String name, String value) {
        this._getHttpServletResponse().addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this._getHttpServletResponse().setIntHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        this._getHttpServletResponse().addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this._getHttpServletResponse().setHeader(name, value);
    }

    public void setStatus(int sc) {
        this._getHttpServletResponse().setStatus(sc);
    }

    public void setStatus(int sc, String sm) {
        this._getHttpServletResponse().setStatus(sc, sm);
    }

    public void addIntHeader(String name, int value) {
        this._getHttpServletResponse().addIntHeader(name, value);
    }

    public void setContentLength(int len) {
        this._getHttpServletResponse().setContentLength(len);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void setLocale(Locale loc) {
        this._getHttpServletResponse().setLocale(loc);
    }

    public ServletOutputStream getOutputStream() throws IllegalStateException, IOException {
        if (this.usingWriter) {
            throw new IllegalStateException("getPortletOutputStream can't be used after getWriter was invoked");
        }
        if (this.wrappedWriter == null) {
            try {
                this.wrappedWriter = this._getHttpServletResponse().getOutputStream();
            }
            catch (IllegalStateException ise) {
                this.wrappedWriter = new PrintWriterServletOutputStream(this._getHttpServletResponse().getWriter(), this._getHttpServletResponse().getCharacterEncoding());
            }
        }
        this.usingStream = true;
        return this.wrappedWriter;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException, IllegalStateException, IOException {
        if (this.usingStream) {
            throw new IllegalStateException("getWriter can't be used after getOutputStream was invoked");
        }
        this.usingWriter = true;
        return this._getHttpServletResponse().getWriter();
    }

    public PortletWindow getInternalPortletWindow() {
        return this.portletWindow;
    }

    HttpServletRequest getHttpDServletRequest() {
        return this.webModuleServletRequest;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public boolean isIncluded() {
        return this.included;
    }
}

