/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.filer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.DBObject;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.FilerException;
import org.apache.xindice.core.filer.Streamable;
import org.apache.xindice.util.Configurable;
import org.apache.xindice.util.Configuration;

public abstract class Paged
implements DBObject,
Configurable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$filer$Paged == null ? (class$org$apache$xindice$core$filer$Paged = Paged.class$("org.apache.xindice.core.filer.Paged")) : class$org$apache$xindice$core$filer$Paged));
    private static final int MAX_DIRTY_SIZE = 128;
    protected static final String CONFIG_PAGESIZE = "pagesize";
    protected static final String CONFIG_PAGECOUNT = "pagecount";
    protected static final String CONFIG_KEYSIZE_MAX = "maxkeysize";
    protected static final String CONFIG_DESCRIPTORS_MAX = "max-descriptors";
    private static final int DEFAULT_PAGESIZE = 4096;
    private static final int DEFAULT_PAGECOUNT = 1024;
    private static final int FILE_HEADER_SIZE = 4096;
    private static final int DEFAULT_KEYSIZE_MAX = 256;
    private static final int DEFAULT_DESCRIPTORS_MAX = 16;
    protected static final byte UNUSED = 0;
    protected static final byte OVERFLOW = 126;
    protected static final byte DELETED = 127;
    protected static final int NO_PAGE = -1;
    private Configuration config;
    private final Map pages = new WeakHashMap();
    private final Object pagesLock = new Object();
    private Map dirty = new HashMap();
    private final Object dirtyLock = new Object();
    private final Stack descriptors = new Stack();
    private int descriptorsCount;
    private int descriptorsMax = 16;
    private boolean opened;
    private File file;
    private final FileHeader fileHeader = this.createFileHeader();
    static /* synthetic */ Class class$org$apache$xindice$core$filer$Paged;

    public Paged() {
    }

    public Paged(File file) {
        this();
        this.setFile(file);
    }

    public void setConfig(Configuration config) {
        this.config = config;
        this.fileHeader.setPageSize(config.getIntAttribute(CONFIG_PAGESIZE, this.fileHeader.getPageSize()));
        this.fileHeader.setPageCount(config.getLongAttribute(CONFIG_PAGECOUNT, this.fileHeader.getPageCount()));
        this.fileHeader.setMaxKeySize(config.getShortAttribute(CONFIG_KEYSIZE_MAX, this.fileHeader.getMaxKeySize()));
        this.descriptorsMax = this.getConfig().getIntAttribute(CONFIG_DESCRIPTORS_MAX, this.descriptorsMax);
    }

    public Configuration getConfig() {
        return this.config;
    }

    protected final void setFile(File file) {
        this.file = file;
    }

    protected final File getFile() {
        return this.file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final RandomAccessFile getDescriptor() throws IOException {
        Stack stack = this.descriptors;
        synchronized (stack) {
            if (!this.descriptors.empty()) {
                return (RandomAccessFile)this.descriptors.pop();
            }
            if (this.descriptorsCount < this.descriptorsMax) {
                ++this.descriptorsCount;
                return new RandomAccessFile(this.file, "rw");
            }
            while (true) {
                try {
                    this.descriptors.wait();
                    return (RandomAccessFile)this.descriptors.pop();
                }
                catch (InterruptedException e) {
                    continue;
                }
                catch (EmptyStackException emptyStackException) {
                    continue;
                }
                break;
            }
        }
    }

    protected final void putDescriptor(RandomAccessFile raf) {
        if (raf != null) {
            Stack stack = this.descriptors;
            synchronized (stack) {
                this.descriptors.push(raf);
                this.descriptors.notify();
            }
        }
    }

    protected final void closeDescriptor(RandomAccessFile raf) {
        if (raf != null) {
            try {
                raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Stack stack = this.descriptors;
            synchronized (stack) {
                --this.descriptorsCount;
            }
        }
    }

    protected final Page getPage(long pageNum) throws IOException {
        PageKey k = new PageKey(pageNum);
        Page p = null;
        Object object = this.pagesLock;
        synchronized (object) {
            WeakReference ref = (WeakReference)this.pages.get(k);
            if (ref != null) {
                p = (Page)ref.get();
            }
            if (p == null) {
                p = new Page(pageNum);
                this.pages.put(p, new WeakReference<Page>(p));
            }
        }
        p.read();
        return p;
    }

    protected final Value readValue(Page page) throws IOException {
        PageHeader sph = page.getPageHeader();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(sph.getRecordLen());
        Page p = page;
        while (true) {
            PageHeader ph = p.getPageHeader();
            p.streamTo(bos);
            long nextPage = ph.getNextPage();
            if (nextPage == -1L) break;
            p = this.getPage(nextPage);
        }
        return new Value(bos.toByteArray());
    }

    protected final Value readValue(long page) throws IOException {
        return this.readValue(this.getPage(page));
    }

    protected final void writeValue(Page page, Value value) throws IOException {
        if (value == null) {
            throw new IOException("Can't write a null value");
        }
        InputStream is = value.getInputStream();
        PageHeader hdr = page.getPageHeader();
        hdr.setRecordLen(value.getLength());
        page.streamFrom(is);
        while (is.available() > 0) {
            Page lpage = page;
            PageHeader lhdr = hdr;
            long np = lhdr.getNextPage();
            if (np != -1L) {
                page = this.getPage(np);
            } else {
                page = this.getFreePage();
                lhdr.setNextPage(page.getPageNum());
            }
            hdr = page.getPageHeader();
            hdr.setStatus((byte)126);
            page.streamFrom(is);
            lpage.write();
        }
        long np = hdr.getNextPage();
        if (np != -1L) {
            this.unlinkPages(np);
        }
        hdr.setNextPage(-1L);
        page.write();
    }

    protected final void writeValue(long page, Value value) throws IOException {
        this.writeValue(this.getPage(page), value);
    }

    protected void unlinkPages(Page page) throws IOException {
        long firstPage = page.pageNum;
        while (page.header.nextPage != -1L) {
            page = this.getPage(page.header.nextPage);
        }
        long lastPage = page.pageNum;
        FileHeader fileHeader = this.fileHeader;
        synchronized (fileHeader) {
            if (this.fileHeader.lastFreePage != -1L) {
                Page p = this.getPage(this.fileHeader.lastFreePage);
                p.header.setNextPage(firstPage);
                p.write();
            }
            if (this.fileHeader.firstFreePage == -1L) {
                this.fileHeader.setFirstFreePage(firstPage);
            }
            this.fileHeader.setLastFreePage(lastPage);
        }
    }

    protected final void unlinkPages(long pageNum) throws IOException {
        this.unlinkPages(this.getPage(pageNum));
    }

    protected final Page getFreePage() throws IOException {
        Page p = null;
        FileHeader fileHeader = this.fileHeader;
        synchronized (fileHeader) {
            if (this.fileHeader.firstFreePage != -1L) {
                p = this.getPage(this.fileHeader.firstFreePage);
                this.fileHeader.setFirstFreePage(p.getPageHeader().nextPage);
                if (this.fileHeader.firstFreePage == -1L) {
                    this.fileHeader.setLastFreePage(-1L);
                }
            }
        }
        if (p == null) {
            p = this.getPage(this.fileHeader.incTotalCount());
        }
        p.header.setNextPage(-1L);
        p.header.setStatus((byte)0);
        return p;
    }

    protected final void checkOpened() throws DBException {
        if (!this.opened) {
            throw new FilerException(247, "Filer is closed");
        }
    }

    protected FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean create() throws DBException {
        try {
            this.createFile();
            this.fileHeader.write();
            this.flush();
            return true;
        }
        catch (Exception e) {
            throw new FilerException(70, "Error creating " + this.file.getName(), e);
        }
    }

    private void createFile() throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = this.getDescriptor();
            long o = (long)this.fileHeader.headerSize + (this.fileHeader.pageCount + 1L) * (long)this.fileHeader.pageSize - 1L;
            raf.seek(o);
            raf.write(0);
            Object var5_3 = null;
            this.putDescriptor(raf);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.putDescriptor(raf);
            throw throwable;
        }
    }

    public synchronized boolean open() throws DBException {
        RandomAccessFile raf = null;
        try {
            try {
                if (this.exists()) {
                    raf = this.getDescriptor();
                    this.fileHeader.read();
                    this.fileHeader.setMaxKeySize(this.config.getShortAttribute(CONFIG_KEYSIZE_MAX, this.fileHeader.getMaxKeySize()));
                    this.opened = true;
                } else {
                    this.opened = false;
                }
                boolean bl = this.opened;
                Object var4_4 = null;
                this.putDescriptor(raf);
                return bl;
            }
            catch (Exception e) {
                throw new FilerException(70, "Error opening " + this.file.getName(), e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.putDescriptor(raf);
            throw throwable;
        }
    }

    public synchronized boolean close() throws DBException {
        if (this.isOpened()) {
            try {
                this.opened = false;
                this.flush();
                Stack stack = this.descriptors;
                synchronized (stack) {
                    int total = this.descriptorsCount;
                    while (!this.descriptors.empty()) {
                        this.closeDescriptor((RandomAccessFile)this.descriptors.pop());
                    }
                    int n = this.descriptorsCount;
                    while (this.descriptorsCount > 0 && n > 0) {
                        this.descriptors.wait(500L);
                        if (this.descriptors.isEmpty()) {
                            --n;
                            continue;
                        }
                        this.closeDescriptor((RandomAccessFile)this.descriptors.pop());
                    }
                    if (this.descriptorsCount > 0) {
                        log.warn((Object)(this.descriptorsCount + " out of " + total + " files were not closed during close."));
                    }
                }
                Object object = this.pagesLock;
                synchronized (object) {
                    this.pages.clear();
                }
            }
            catch (Exception e) {
                this.opened = true;
                throw new FilerException(70, "Error closing " + this.file.getName(), e);
            }
        }
        return true;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean drop() throws DBException {
        try {
            this.close();
            if (this.exists()) {
                return this.getFile().delete();
            }
            return true;
        }
        catch (Exception e) {
            throw new FilerException(271, "Can't drop " + this.file.getName(), e);
        }
    }

    void addDirty(Page page) throws IOException {
        boolean flush;
        Object object = this.dirtyLock;
        synchronized (object) {
            this.dirty.put(page, page);
            flush = this.dirty.size() > 128;
        }
        if (flush) {
            try {
                this.flush();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public void flush() throws DBException {
        Collection pages;
        int error = 0;
        Object object = this.dirtyLock;
        synchronized (object) {
            pages = this.dirty.values();
            this.dirty = new HashMap();
        }
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            Page p = (Page)i.next();
            try {
                p.flush();
            }
            catch (Exception e) {
                log.warn((Object)("Exception while flushing page " + p.pageNum), (Throwable)e);
                ++error;
            }
        }
        if (this.fileHeader.dirty) {
            try {
                this.fileHeader.write();
            }
            catch (Exception e) {
                log.warn((Object)"Exception while flushing file header", (Throwable)e);
                ++error;
            }
        }
        if (error != 0) {
            throw new FilerException(70, "Error performing flush! Failed to flush " + error + " pages!");
        }
    }

    protected abstract FileHeader createFileHeader();

    protected abstract PageHeader createPageHeader();

    public static Value[] insertArrayValue(Value[] vals, Value val, int idx) {
        Value[] newVals = new Value[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static Value[] deleteArrayValue(Value[] vals, int idx) {
        Value[] newVals = new Value[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    public static long[] insertArrayLong(long[] vals, long val, int idx) {
        long[] newVals = new long[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static long[] deleteArrayLong(long[] vals, int idx) {
        long[] newVals = new long[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    public static int[] insertArrayInt(int[] vals, int val, int idx) {
        int[] newVals = new int[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static int[] deleteArrayInt(int[] vals, int idx) {
        int[] newVals = new int[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    public static short[] insertArrayShort(short[] vals, short val, int idx) {
        short[] newVals = new short[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static short[] deleteArrayShort(short[] vals, int idx) {
        short[] newVals = new short[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected final class Page
    extends PageKey {
        private final PageHeader header;
        private final long offset;
        private byte[] data;
        private int keyPos;
        private int dataPos;

        private Page(long pageNum) {
            super(pageNum);
            this.header = Paged.this.createPageHeader();
            this.offset = (long)Paged.this.fileHeader.headerSize + pageNum * (long)Paged.this.fileHeader.pageSize;
        }

        public synchronized void read() throws IOException {
            if (this.data == null) {
                RandomAccessFile raf = null;
                try {
                    byte[] data = new byte[Paged.this.fileHeader.pageSize];
                    raf = Paged.this.getDescriptor();
                    raf.seek(this.offset);
                    raf.read(data);
                    ByteArrayInputStream bis = new ByteArrayInputStream(data);
                    this.header.read(new DataInputStream(bis));
                    this.keyPos = Paged.this.fileHeader.pageHeaderSize;
                    this.dataPos = this.keyPos + this.header.keyLen;
                    this.data = data;
                    Object var5_4 = null;
                    Paged.this.putDescriptor(raf);
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    Paged.this.putDescriptor(raf);
                    throw throwable;
                }
            }
        }

        public void write() throws IOException {
            Page page = this;
            synchronized (page) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(Paged.this.fileHeader.getPageHeaderSize());
                this.header.write(new DataOutputStream(bos));
                byte[] b = bos.toByteArray();
                System.arraycopy(b, 0, this.data, 0, b.length);
            }
            Paged.this.addDirty(this);
        }

        public synchronized void flush() throws IOException {
            RandomAccessFile raf = null;
            try {
                raf = Paged.this.getDescriptor();
                if (this.offset >= raf.length()) {
                    long o = (long)Paged.this.fileHeader.headerSize + (Paged.this.fileHeader.totalCount * 3L / 2L + 1L) * (long)Paged.this.fileHeader.pageSize - 1L;
                    raf.seek(o);
                    raf.writeByte(0);
                }
                raf.seek(this.offset);
                raf.write(this.data);
                Object var5_3 = null;
                Paged.this.putDescriptor(raf);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                Paged.this.putDescriptor(raf);
                throw throwable;
            }
        }

        public PageHeader getPageHeader() {
            return this.header;
        }

        public synchronized void setKey(Key key) {
            this.header.setKey(key);
            key.copyTo(this.data, this.keyPos);
            this.dataPos = this.keyPos + this.header.keyLen;
        }

        public synchronized Key getKey() {
            if (this.header.keyLen == 0) {
                return null;
            }
            return new Key(this.data, this.keyPos, this.header.keyLen);
        }

        public synchronized void streamTo(OutputStream os) throws IOException {
            if (this.header.dataLen > 0) {
                os.write(this.data, this.dataPos, this.header.dataLen);
            }
        }

        public synchronized void streamFrom(InputStream is) throws IOException {
            int avail = is.available();
            this.header.dataLen = Paged.this.fileHeader.workSize - this.header.keyLen;
            if (avail < this.header.dataLen) {
                this.header.dataLen = avail;
            }
            if (this.header.dataLen > 0) {
                is.read(this.data, this.keyPos + this.header.keyLen, this.header.dataLen);
            }
        }
    }

    protected static class PageKey
    implements Comparable {
        protected final long pageNum;

        public PageKey(long pageNum) {
            this.pageNum = pageNum;
        }

        public long getPageNum() {
            return this.pageNum;
        }

        public int compareTo(Object o) {
            return (int)(this.pageNum - ((PageKey)o).pageNum);
        }

        public int hashCode() {
            return (int)(this.pageNum ^ this.pageNum >> 32);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PageKey) {
                return this.pageNum == ((PageKey)obj).pageNum;
            }
            return false;
        }
    }

    protected static abstract class PageHeader
    implements Streamable {
        private boolean dirty;
        private byte status = 0;
        private short keyLen;
        private int keyHash;
        private int dataLen;
        private int recordLen;
        private long nextPage = -1L;

        public PageHeader() {
        }

        public PageHeader(DataInput dis) throws IOException {
            this.read(dis);
        }

        public synchronized void read(DataInput dis) throws IOException {
            this.status = dis.readByte();
            this.dirty = false;
            if (this.status == 0) {
                return;
            }
            this.keyLen = dis.readShort();
            this.keyHash = dis.readInt();
            this.dataLen = dis.readInt();
            this.recordLen = dis.readInt();
            this.nextPage = dis.readLong();
        }

        public synchronized void write(DataOutput dos) throws IOException {
            this.dirty = false;
            dos.writeByte(this.status);
            dos.writeShort(this.keyLen);
            dos.writeInt(this.keyHash);
            dos.writeInt(this.dataLen);
            dos.writeInt(this.recordLen);
            dos.writeLong(this.nextPage);
        }

        public final synchronized boolean isDirty() {
            return this.dirty;
        }

        public final synchronized void setDirty() {
            this.dirty = true;
        }

        public final synchronized void setStatus(byte status) {
            this.status = status;
            this.dirty = true;
        }

        public final synchronized byte getStatus() {
            return this.status;
        }

        public final synchronized void setKey(Key key) {
            this.setRecordLen(0);
            this.dataLen = 0;
            this.keyHash = key.getHash();
            this.keyLen = (short)key.getLength();
            this.dirty = true;
        }

        public final synchronized void setKeyLen(short keyLen) {
            this.keyLen = keyLen;
            this.dirty = true;
        }

        public final synchronized short getKeyLen() {
            return this.keyLen;
        }

        public final synchronized void setKeyHash(int keyHash) {
            this.keyHash = keyHash;
            this.dirty = true;
        }

        public final synchronized int getKeyHash() {
            return this.keyHash;
        }

        public final synchronized void setDataLen(int dataLen) {
            this.dataLen = dataLen;
            this.dirty = true;
        }

        public final synchronized int getDataLen() {
            return this.dataLen;
        }

        public synchronized void setRecordLen(int recordLen) {
            this.recordLen = recordLen;
            this.dirty = true;
        }

        public final synchronized int getRecordLen() {
            return this.recordLen;
        }

        public final synchronized void setNextPage(long nextPage) {
            this.nextPage = nextPage;
            this.dirty = true;
        }

        public final synchronized long getNextPage() {
            return this.nextPage;
        }
    }

    protected abstract class FileHeader {
        private boolean dirty;
        private int workSize;
        private short headerSize;
        private int pageSize = 4096;
        private long pageCount = 1024L;
        private long totalCount;
        private long firstFreePage = -1L;
        private long lastFreePage = -1L;
        private byte pageHeaderSize = (byte)64;
        private short maxKeySize = (short)256;
        private long recordCount;

        public FileHeader() {
            this.headerSize = (short)4096;
            this.calculateWorkSize();
        }

        public final synchronized void read() throws IOException {
            RandomAccessFile raf = Paged.this.getDescriptor();
            try {
                raf.seek(0L);
                this.read(raf);
                this.calculateWorkSize();
                Object var3_2 = null;
                Paged.this.putDescriptor(raf);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Paged.this.putDescriptor(raf);
                throw throwable;
            }
        }

        protected synchronized void read(RandomAccessFile raf) throws IOException {
            this.headerSize = raf.readShort();
            this.pageSize = raf.readInt();
            this.pageCount = raf.readLong();
            this.totalCount = raf.readLong();
            this.firstFreePage = raf.readLong();
            this.lastFreePage = raf.readLong();
            this.pageHeaderSize = raf.readByte();
            this.maxKeySize = raf.readShort();
            this.recordCount = raf.readLong();
        }

        public final synchronized void write() throws IOException {
            if (this.dirty) {
                RandomAccessFile raf = Paged.this.getDescriptor();
                try {
                    raf.seek(0L);
                    this.write(raf);
                    this.dirty = false;
                    Object var3_2 = null;
                    Paged.this.putDescriptor(raf);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    Paged.this.putDescriptor(raf);
                    throw throwable;
                }
            }
        }

        protected synchronized void write(RandomAccessFile raf) throws IOException {
            raf.writeShort(this.headerSize);
            raf.writeInt(this.pageSize);
            raf.writeLong(this.pageCount);
            raf.writeLong(this.totalCount);
            raf.writeLong(this.firstFreePage);
            raf.writeLong(this.lastFreePage);
            raf.writeByte(this.pageHeaderSize);
            raf.writeShort(this.maxKeySize);
            raf.writeLong(this.recordCount);
        }

        public final synchronized void setDirty() {
            this.dirty = true;
        }

        public final synchronized boolean isDirty() {
            return this.dirty;
        }

        public final synchronized void setHeaderSize(short headerSize) {
            this.headerSize = headerSize;
            this.dirty = true;
        }

        public final synchronized short getHeaderSize() {
            return this.headerSize;
        }

        public final synchronized void setPageSize(int pageSize) {
            this.pageSize = pageSize;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final synchronized int getPageSize() {
            return this.pageSize;
        }

        public final synchronized void setPageCount(long pageCount) {
            this.pageCount = pageCount;
            this.dirty = true;
        }

        public final synchronized long getPageCount() {
            return this.pageCount;
        }

        public final synchronized void setTotalCount(long totalCount) {
            this.totalCount = totalCount;
            this.dirty = true;
        }

        public final synchronized long incTotalCount() {
            this.dirty = true;
            return this.totalCount++;
        }

        public final synchronized long getTotalCount() {
            return this.totalCount;
        }

        public final synchronized void setFirstFreePage(long firstFreePage) {
            this.firstFreePage = firstFreePage;
            this.dirty = true;
        }

        public final synchronized long getFirstFreePage() {
            return this.firstFreePage;
        }

        public final synchronized void setLastFreePage(long lastFreePage) {
            this.lastFreePage = lastFreePage;
            this.dirty = true;
        }

        public final synchronized long getLastFreePage() {
            return this.lastFreePage;
        }

        public final synchronized void setPageHeaderSize(byte pageHeaderSize) {
            this.pageHeaderSize = pageHeaderSize;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final synchronized byte getPageHeaderSize() {
            return this.pageHeaderSize;
        }

        public final synchronized void setMaxKeySize(short maxKeySize) {
            this.maxKeySize = maxKeySize;
            this.dirty = true;
        }

        public final synchronized short getMaxKeySize() {
            return this.maxKeySize;
        }

        public final synchronized void incRecordCount() {
            ++this.recordCount;
            this.dirty = true;
        }

        public final synchronized void decRecordCount() {
            --this.recordCount;
            this.dirty = true;
        }

        public final synchronized long getRecordCount() {
            return this.recordCount;
        }

        private synchronized void calculateWorkSize() {
            this.workSize = this.pageSize - this.pageHeaderSize;
        }

        public final synchronized int getWorkSize() {
            return this.workSize;
        }
    }
}

