/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.indexer;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.indexer.IndexMatch;
import org.apache.xindice.core.indexer.IndexQuery;
import org.apache.xindice.core.indexer.Indexer;
import org.apache.xindice.core.query.QueryEngine;
import org.apache.xindice.util.Configuration;

public class MemValueIndexer
implements Indexer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$indexer$MemValueIndexer == null ? (class$org$apache$xindice$core$indexer$MemValueIndexer = MemValueIndexer.class$("org.apache.xindice.core.indexer.MemValueIndexer")) : class$org$apache$xindice$core$indexer$MemValueIndexer));
    private static final int STRING = 0;
    private static final int TRIMMED = 1;
    private static final int SHORT = 2;
    private static final int INTEGER = 3;
    private static final int LONG = 4;
    private static final int FLOAT = 5;
    private static final int DOUBLE = 6;
    private static final int BYTE = 7;
    private static final int CHAR = 8;
    private static final int BOOLEAN = 9;
    private static final String NAME = "name";
    private static final String PATTERN = "pattern";
    private static final String TYPE = "type";
    private static final String STRING_VAL = "string";
    private static final String TRIMMED_VAL = "trimmed";
    private static final String SHORT_VAL = "short";
    private static final String INT_VAL = "int";
    private static final String LONG_VAL = "long";
    private static final String FLOAT_VAL = "float";
    private static final String DOUBLE_VAL = "double";
    private static final String BYTE_VAL = "byte";
    private static final String CHAR_VAL = "char";
    private static final String BOOLEAN_VAL = "boolean";
    private static final IndexMatch[] EMPTY_INDEX_MATCH_ARRAY = new IndexMatch[0];
    private Configuration itsConfig;
    private String itsName;
    private String itsPattern;
    private int itsValueType = 0;
    private String itsValueTypeName = "string";
    private TreeMap itsValues = null;
    private int itsValueLocatorCount = 0;
    private boolean itsOpen = false;
    static /* synthetic */ Class class$org$apache$xindice$core$indexer$MemValueIndexer;

    public void setCollection(Collection theCollection) {
    }

    public String getIndexStyle() {
        return "Node:Value";
    }

    public String getPattern() {
        return this.itsPattern;
    }

    public synchronized void remove(String theValue, Key theKey, int thePosition, int theLength, short theElementID, short theAttributeID) throws DBException {
        Object aValue = this.itsValueType != 0 ? this.getTypedValue(theValue) : theValue;
        TreeSet aLocatorSet = (TreeSet)this.itsValues.get(aValue);
        if (aLocatorSet != null && aLocatorSet.remove(new ValueLocator(theKey, thePosition, theLength, theElementID, theAttributeID))) {
            if (aLocatorSet.size() == 0) {
                this.itsValues.remove(theValue);
            }
            --this.itsValueLocatorCount;
        }
    }

    public synchronized void add(String theValue, Key theKey, int thePosition, int theLength, short theElementID, short theAttributeID) throws DBException {
        Object aValue = this.itsValueType != 0 ? this.getTypedValue(theValue) : theValue;
        TreeSet<ValueLocator> aLocatorSet = (TreeSet<ValueLocator>)this.itsValues.get(aValue);
        if (aLocatorSet == null) {
            aLocatorSet = new TreeSet<ValueLocator>();
            this.itsValues.put(aValue, aLocatorSet);
        }
        aLocatorSet.add(new ValueLocator(theKey, thePosition, theLength, theElementID, theAttributeID));
        ++this.itsValueLocatorCount;
    }

    public synchronized IndexMatch[] queryMatches(IndexQuery theQuery) throws DBException {
        int anIndex;
        IndexMatch[] aResult = null;
        Value[] aQueryValueList = theQuery.getValues();
        Object[] aMatchValueArray = new Object[aQueryValueList.length];
        if (this.itsValueType != 0) {
            anIndex = 0;
            while (anIndex < aQueryValueList.length) {
                aMatchValueArray[anIndex] = this.getTypedValue(aQueryValueList[anIndex].toString());
                ++anIndex;
            }
        } else {
            anIndex = 0;
            while (anIndex < aQueryValueList.length) {
                aMatchValueArray[anIndex] = aQueryValueList[anIndex].toString();
                ++anIndex;
            }
        }
        Object aLowEndpoint = aMatchValueArray[0];
        Object aHighEndpoint = aMatchValueArray[aMatchValueArray.length - 1];
        int anOperator = theQuery.getOperator();
        switch (anOperator) {
            default: {
                throw new DBException(370, "Unimplemented index query operation code (code = " + anOperator + ")");
            }
            case 1: {
                TreeSet aLocatorSet = (TreeSet)this.itsValues.get(aLowEndpoint);
                if (aLocatorSet == null) break;
                aResult = new IndexMatch[aLocatorSet.size()];
                this.addMatches(aResult, 0, aLocatorSet);
                break;
            }
            case -1: {
                TreeSet anExcludedLocatorSet = (TreeSet)this.itsValues.get(aLowEndpoint);
                Iterator aValueIterator = this.itsValues.entrySet().iterator();
                int aResultIndex = 0;
                if (anExcludedLocatorSet == null) {
                    aResult = new IndexMatch[this.itsValueLocatorCount];
                    while (aValueIterator.hasNext()) {
                        Iterator aLocatorIterator = ((TreeSet)aValueIterator.next().getValue()).iterator();
                        while (aLocatorIterator.hasNext()) {
                            ValueLocator aLocator = (ValueLocator)aLocatorIterator.next();
                            aResult[aResultIndex] = new IndexMatch(new Key(aLocator.getKey()), aLocator.getPosition(), aLocator.getLength(), aLocator.getElementID(), aLocator.getAttributeID());
                            ++aResultIndex;
                        }
                    }
                } else {
                    aResult = new IndexMatch[this.itsValueLocatorCount - anExcludedLocatorSet.size()];
                    while (aValueIterator.hasNext()) {
                        TreeSet aLocatorSet = (TreeSet)aValueIterator.next().getValue();
                        if (aLocatorSet == anExcludedLocatorSet) continue;
                        Iterator aLocatorIterator = ((TreeSet)aValueIterator.next().getValue()).iterator();
                        while (aLocatorIterator.hasNext()) {
                            ValueLocator aLocator = (ValueLocator)aLocatorIterator.next();
                            aResult[aResultIndex] = new IndexMatch(new Key(aLocator.getKey()), aLocator.getPosition(), aLocator.getLength(), aLocator.getElementID(), aLocator.getAttributeID());
                            ++aResultIndex;
                        }
                    }
                }
                break;
            }
            case 5: {
                aLowEndpoint = this.getNextValueOf(aLowEndpoint);
                if (aLowEndpoint == null || ((Comparable)aLowEndpoint).compareTo(aHighEndpoint) >= 0) {
                    aResult = new IndexMatch[]{};
                    break;
                }
                aResult = this.getIndexMatchArray(this.itsValues.subMap(aLowEndpoint, aHighEndpoint));
                break;
            }
            case 4: {
                aResult = this.getIndexMatchArray(this.getBWSubmap(aLowEndpoint, aHighEndpoint));
                break;
            }
            case 7: {
                if (!(aLowEndpoint instanceof String)) {
                    aLowEndpoint = aLowEndpoint.toString();
                }
                aResult = this.getIndexMatchArray(this.getSWSubmap((String)aLowEndpoint));
                break;
            }
            case 6: {
                aResult = this.getIndexMatchArray(this.getBWSubmap(aLowEndpoint, aLowEndpoint), aMatchValueArray, false);
                break;
            }
            case -5: {
                aResult = this.getIndexMatchArray(this.getLTSubmap(aLowEndpoint), this.getGTSubmap(aHighEndpoint));
                break;
            }
            case -4: {
                aResult = this.getIndexMatchArray(this.getLEQSubmap(aLowEndpoint), this.getGEQSubmap(aHighEndpoint));
                break;
            }
            case -7: {
                if (!(aLowEndpoint instanceof String)) {
                    aLowEndpoint = aLowEndpoint.toString();
                }
                aResult = this.getIndexMatchArray(this.getLTSubmap(aLowEndpoint), this.getGTSubmap(aLowEndpoint));
                break;
            }
            case 3: {
                aResult = this.getIndexMatchArray(this.getLTSubmap(aLowEndpoint));
                break;
            }
            case -2: {
                aResult = this.getIndexMatchArray(this.getLEQSubmap(aLowEndpoint));
                break;
            }
            case 2: {
                aResult = this.getIndexMatchArray(this.getGTSubmap(aLowEndpoint));
                break;
            }
            case -3: {
                aResult = this.getIndexMatchArray(this.getGEQSubmap(aLowEndpoint));
                break;
            }
            case -6: {
                aResult = this.getIndexMatchArray(this.getLTSubmap(aLowEndpoint), this.getBWSubmap(aLowEndpoint, aLowEndpoint), this.getGTSubmap(aHighEndpoint), aMatchValueArray, true);
                break;
            }
            case 0: {
                aResult = this.getIndexMatchArray(this.itsValues);
            }
        }
        return aResult == null ? EMPTY_INDEX_MATCH_ARRAY : aResult;
    }

    private SortedMap getSWSubmap(String theLowEndpoint) {
        String aHighEndpoint = (String)this.getNextValueOf(theLowEndpoint, 0);
        SortedMap aSubmap = aHighEndpoint == null ? this.itsValues.tailMap(theLowEndpoint) : this.itsValues.subMap(theLowEndpoint, aHighEndpoint);
        return aSubmap == null || aSubmap.size() == 0 ? null : aSubmap;
    }

    private SortedMap getBWSubmap(Object theLowEndpoint, Object theHighEndpoint) {
        SortedMap<Object, TreeSet<Object>> aSubmap = null;
        int aComparison = ((Comparable)theLowEndpoint).compareTo(theHighEndpoint);
        if (aComparison == 0) {
            TreeSet aLocatorSet = (TreeSet)this.itsValues.get(theLowEndpoint);
            if (aLocatorSet != null) {
                aSubmap = new TreeMap<Object, TreeSet>(ValueComparator.INSTANCE);
                aSubmap.put(theLowEndpoint, aLocatorSet);
            }
        } else if (aComparison < 0) {
            theHighEndpoint = theHighEndpoint instanceof String ? this.getNextValueOf(theHighEndpoint, 0) : this.getNextValueOf(theHighEndpoint);
            aSubmap = theHighEndpoint == null ? this.itsValues.tailMap(theLowEndpoint) : this.itsValues.subMap(theLowEndpoint, theHighEndpoint);
        }
        return aSubmap == null || aSubmap.size() == 0 ? null : aSubmap;
    }

    private SortedMap getLTSubmap(Object theHighEndpoint) {
        SortedMap aSubmap = this.itsValues.headMap(theHighEndpoint);
        return aSubmap == null || aSubmap.size() == 0 ? null : aSubmap;
    }

    private SortedMap getLEQSubmap(Object theHighEndpoint) {
        Object object = theHighEndpoint = theHighEndpoint instanceof String ? this.getNextValueOf(theHighEndpoint, 0) : this.getNextValueOf(theHighEndpoint);
        if (theHighEndpoint == null) {
            return this.itsValues;
        }
        return this.getLTSubmap(theHighEndpoint);
    }

    private SortedMap getGTSubmap(Object theLowEndpoint) {
        Object object = theLowEndpoint = theLowEndpoint instanceof String ? this.getNextValueOf(theLowEndpoint, 0) : this.getNextValueOf(theLowEndpoint);
        if (theLowEndpoint == null) {
            return null;
        }
        return this.getGEQSubmap(theLowEndpoint);
    }

    private SortedMap getGEQSubmap(Object theLowEndpoint) {
        SortedMap aSubmap = this.itsValues.tailMap(theLowEndpoint);
        return aSubmap == null || aSubmap.size() == 0 ? null : aSubmap;
    }

    private IndexMatch[] getIndexMatchArray(Map theMap) {
        IndexMatch[] aResult;
        if (theMap != null) {
            aResult = new IndexMatch[this.countLocators(theMap)];
            this.addMatches(aResult, 0, theMap);
        } else {
            aResult = new IndexMatch[]{};
        }
        return aResult;
    }

    private IndexMatch[] getIndexMatchArray(Map theFirstMap, Map theSecondMap) {
        int aLocatorCount = 0;
        aLocatorCount += this.countLocators(theFirstMap);
        IndexMatch[] aResult = new IndexMatch[aLocatorCount += this.countLocators(theSecondMap)];
        aLocatorCount = 0;
        aLocatorCount = this.addMatches(aResult, aLocatorCount, theFirstMap);
        this.addMatches(aResult, aLocatorCount, theSecondMap);
        return aResult;
    }

    private IndexMatch[] getIndexMatchArray(Map theMap, Object[] theFilterList, boolean theExcludeFlag) {
        if (theMap == null) {
            return new IndexMatch[0];
        }
        LinkedList<TreeSet> aResultList = new LinkedList<TreeSet>();
        int aLocatorCount = 0;
        Iterator aValueIterator = theMap.entrySet().iterator();
        while (aValueIterator.hasNext()) {
            boolean aValueInFilterList;
            Map.Entry anEntry = aValueIterator.next();
            Object aKey = anEntry.getKey();
            boolean bl = aValueInFilterList = Arrays.binarySearch(theFilterList, aKey, ValueComparator.INSTANCE) >= 0;
            if ((!theExcludeFlag || aValueInFilterList) && (theExcludeFlag || !aValueInFilterList)) continue;
            TreeSet aSet = (TreeSet)anEntry.getValue();
            aLocatorCount += aSet.size();
            aResultList.add(aSet);
        }
        IndexMatch[] aResult = new IndexMatch[aLocatorCount];
        aValueIterator = aResultList.iterator();
        aLocatorCount = 0;
        while (aValueIterator.hasNext()) {
            aLocatorCount = this.addMatches(aResult, aLocatorCount, (java.util.Collection)((Object)aValueIterator.next()));
        }
        return aResult;
    }

    private IndexMatch[] getIndexMatchArray(Map theFirstMap, Map theFilterThisMap, Map theThirdMap, Object[] theFilterList, boolean theExcludeFlag) {
        if (theFilterThisMap == null) {
            return this.getIndexMatchArray(theFirstMap, theThirdMap);
        }
        LinkedList<TreeSet> aResultList = new LinkedList<TreeSet>();
        int aLocatorCount = 0;
        aLocatorCount += this.countLocators(theFirstMap);
        Iterator aValueIterator = theFirstMap.entrySet().iterator();
        while (aValueIterator.hasNext()) {
            boolean aValueInFilterList;
            Map.Entry anEntry = aValueIterator.next();
            Object aKey = anEntry.getKey();
            boolean bl = aValueInFilterList = Arrays.binarySearch(theFilterList, aKey, ValueComparator.INSTANCE) >= 0;
            if ((!theExcludeFlag || aValueInFilterList) && (theExcludeFlag || !aValueInFilterList)) continue;
            TreeSet aSet = (TreeSet)anEntry.getValue();
            aLocatorCount += aSet.size();
            aResultList.add(aSet);
        }
        IndexMatch[] aResult = new IndexMatch[aLocatorCount += this.countLocators(theThirdMap)];
        aLocatorCount = 0;
        aLocatorCount = this.addMatches(aResult, aLocatorCount, theFirstMap);
        aValueIterator = aResultList.iterator();
        while (aValueIterator.hasNext()) {
            aLocatorCount = this.addMatches(aResult, aLocatorCount, (java.util.Collection)((Object)aValueIterator.next()));
        }
        this.addMatches(aResult, aLocatorCount, theThirdMap);
        return aResult;
    }

    public void flush() throws DBException {
    }

    public void setConfig(Configuration theConfig) {
        this.itsConfig = theConfig;
        try {
            this.itsName = theConfig.getAttribute(NAME);
            this.itsPattern = theConfig.getAttribute(PATTERN);
            String type = theConfig.getAttribute(TYPE, STRING_VAL).toLowerCase();
            if (type.equals(STRING_VAL)) {
                this.itsValueType = 0;
            } else if (type.equals(TRIMMED_VAL)) {
                this.itsValueType = 1;
            } else if (type.equals(SHORT_VAL)) {
                this.itsValueType = 2;
            } else if (type.equals(INT_VAL)) {
                this.itsValueType = 3;
            } else if (type.equals(LONG_VAL)) {
                this.itsValueType = 4;
            } else if (type.equals(FLOAT_VAL)) {
                this.itsValueType = 5;
            } else if (type.equals(DOUBLE_VAL)) {
                this.itsValueType = 6;
            } else if (type.equals(BYTE_VAL)) {
                this.itsValueType = 7;
            } else if (type.equals(CHAR_VAL)) {
                this.itsValueType = 8;
            } else if (type.equals(BOOLEAN_VAL)) {
                this.itsValueType = 9;
            } else if (this.itsPattern.indexOf(64) != -1) {
                log.warn((Object)"Unrecognized value type, defaulting to 'string'");
                this.itsValueType = 0;
            } else {
                log.warn((Object)"Unrecognized value type, defaulting to 'trimmed'");
                this.itsValueType = 1;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception while setting configuration", (Throwable)e);
        }
    }

    public Configuration getConfig() {
        return this.itsConfig;
    }

    public boolean create() throws DBException {
        this.itsOpen = false;
        this.itsValues = new TreeMap(ValueComparator.INSTANCE);
        return true;
    }

    public synchronized boolean open() throws DBException {
        if (this.itsValues == null || this.itsConfig == null) {
            return false;
        }
        this.itsOpen = true;
        return true;
    }

    public synchronized boolean isOpened() throws DBException {
        return this.itsValues != null && this.itsOpen;
    }

    public synchronized boolean exists() throws DBException {
        return this.itsValues != null;
    }

    public synchronized boolean drop() throws DBException {
        this.itsOpen = false;
        this.itsValues = null;
        return true;
    }

    public synchronized boolean close() throws DBException {
        this.itsOpen = false;
        return true;
    }

    public String getName() {
        return this.itsName;
    }

    private Object getTypedValue(String theValue) {
        block17: {
            if (this.itsValueType != 0 && this.itsValueType != 1) {
                theValue = theValue.trim();
            } else if (this.itsValueType == 1) {
                theValue = QueryEngine.normalizeString(theValue);
            }
            if (theValue.length() == 0) {
                return EmptyValue.INSTANCE;
            }
            try {
                switch (this.itsValueType) {
                    default: {
                        break;
                    }
                    case 0: 
                    case 1: {
                        return theValue;
                    }
                    case 2: {
                        return new Short(theValue);
                    }
                    case 3: {
                        return new Integer(theValue);
                    }
                    case 4: {
                        return new Long(theValue);
                    }
                    case 5: {
                        return new Float(theValue);
                    }
                    case 6: {
                        return new Double(theValue);
                    }
                    case 7: {
                        return new Byte(theValue);
                    }
                    case 8: {
                        return new Character(theValue.charAt(0));
                    }
                    case 9: {
                        return "[true][yes][1][y][on]".indexOf("[" + theValue.toLowerCase() + "]") == -1 ? new Byte(0) : new Byte(1);
                    }
                }
            }
            catch (Exception anException) {
                if (!log.isDebugEnabled()) break block17;
                log.debug((Object)("Exception while converting value \"" + theValue + "\"  from String to " + this.itsValueTypeName), (Throwable)anException);
            }
        }
        return "";
    }

    private Object getNextValueOf(Object theValue) {
        return this.getNextValueOf(theValue, this.itsValueType);
    }

    private Object getNextValueOf(Object theValue, int theType) {
        if (theValue instanceof EmptyValue) {
            return "\u0000";
        }
        Object aReturn = null;
        switch (theType) {
            default: {
                break;
            }
            case 0: 
            case 1: {
                int aLength = ((String)theValue).length();
                if (aLength == 0) {
                    return theValue + "\u0000";
                }
                char aLastChar = ((String)theValue).charAt(aLength - 1);
                if (aLastChar == '\uffff') {
                    return theValue + "\u0000";
                }
                aLastChar = (char)(aLastChar + '\u0001');
                aReturn = ((String)theValue).substring(0, aLength - 1) + aLastChar;
                break;
            }
            case 2: {
                short aValue = (Short)theValue;
                aReturn = aValue == Short.MAX_VALUE ? null : new Short((short)(aValue + 1));
                break;
            }
            case 3: {
                int aValue = (Integer)theValue;
                aReturn = aValue == Integer.MAX_VALUE ? null : new Integer(aValue + 1);
                break;
            }
            case 4: {
                long aValue = (Long)theValue;
                aReturn = aValue == Long.MAX_VALUE ? null : new Long(aValue + 1L);
                break;
            }
            case 5: {
                float aValue = ((Float)theValue).floatValue();
                aReturn = aValue == Float.MAX_VALUE ? null : new Float(aValue + Float.MIN_VALUE);
                break;
            }
            case 6: {
                double aValue = (Double)theValue;
                aReturn = aValue == Double.MAX_VALUE ? null : new Double(aValue + Double.MIN_VALUE);
                break;
            }
            case 8: {
                char aValue = ((Character)theValue).charValue();
                aReturn = aValue == '\uffff' ? null : new Character((char)(aValue + '\u0001'));
                break;
            }
            case 7: 
            case 9: {
                byte aValue = (Byte)theValue;
                aReturn = aValue == 127 ? null : new Byte((byte)(aValue + 1));
            }
        }
        return aReturn;
    }

    private int countLocators(Map theMap) {
        int aCount = 0;
        if (theMap != null) {
            Iterator aValueIterator = theMap.entrySet().iterator();
            while (aValueIterator.hasNext()) {
                aCount += ((Set)aValueIterator.next().getValue()).size();
            }
        }
        return aCount;
    }

    private int addMatches(IndexMatch[] theArray, int theStartIndex, Map theMap) {
        if (theMap == null) {
            return theStartIndex;
        }
        Iterator aValueIterator = theMap.entrySet().iterator();
        while (aValueIterator.hasNext()) {
            Iterator aLocatorIterator = ((TreeSet)aValueIterator.next().getValue()).iterator();
            while (aLocatorIterator.hasNext()) {
                ValueLocator aLocator = (ValueLocator)aLocatorIterator.next();
                theArray[theStartIndex] = new IndexMatch(new Key(aLocator.getKey()), aLocator.getPosition(), aLocator.getLength(), aLocator.getElementID(), aLocator.getAttributeID());
                ++theStartIndex;
            }
        }
        return theStartIndex;
    }

    private int addMatches(IndexMatch[] theArray, int theStartIndex, java.util.Collection theSet) {
        if (theSet == null) {
            return theStartIndex;
        }
        Iterator aLocatorIterator = theSet.iterator();
        while (aLocatorIterator.hasNext()) {
            ValueLocator aLocator = (ValueLocator)aLocatorIterator.next();
            theArray[theStartIndex] = new IndexMatch(new Key(aLocator.getKey()), aLocator.getPosition(), aLocator.getLength(), aLocator.getElementID(), aLocator.getAttributeID());
            ++theStartIndex;
        }
        return theStartIndex;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ValueLocator
    implements Comparable {
        private byte[] itsKey;
        private final int itsPosition;
        private final int itsLength;
        private final short itsElementID;
        private final short itsAttributeID;

        public ValueLocator(Key theKey, int thePosition, int theLength, short theElementID, short theAttributeID) {
            this.itsKey = theKey.getData();
            this.itsPosition = thePosition;
            this.itsLength = theLength;
            this.itsElementID = theElementID;
            this.itsAttributeID = theAttributeID;
        }

        public byte[] getKey() {
            return this.itsKey;
        }

        public final int getPosition() {
            return this.itsPosition;
        }

        public final int getLength() {
            return this.itsLength;
        }

        public final short getElementID() {
            return this.itsElementID;
        }

        public final short getAttributeID() {
            return this.itsAttributeID;
        }

        public final int compareTo(Object theObject) {
            if (!(theObject instanceof ValueLocator)) {
                throw new ClassCastException("Can't compare object of type " + theObject.getClass().getName() + " to ValueLocator");
            }
            ValueLocator aCompareTo = (ValueLocator)theObject;
            byte[] aCompareToKey = aCompareTo.itsKey;
            int aMaxLength = this.itsKey.length > aCompareToKey.length ? aCompareToKey.length : this.itsKey.length;
            int anIndex = 0;
            while (anIndex < aMaxLength) {
                byte aByteThis = this.itsKey[anIndex];
                byte aByteThat = aCompareToKey[anIndex];
                if (aByteThis != aByteThat) {
                    return aByteThis > aByteThat ? 1 : -1;
                }
                ++anIndex;
            }
            if (this.itsKey.length != aCompareToKey.length) {
                return this.itsKey.length > aCompareToKey.length ? 1 : -1;
            }
            if (this.itsPosition != aCompareTo.itsPosition) {
                return this.itsPosition > aCompareTo.itsPosition ? 1 : -1;
            }
            if (this.itsLength != aCompareTo.itsLength) {
                return this.itsLength > aCompareTo.itsLength ? 1 : -1;
            }
            if (this.itsElementID != aCompareTo.itsElementID) {
                return this.itsElementID > aCompareTo.itsElementID ? 1 : -1;
            }
            if (this.itsAttributeID != aCompareTo.itsAttributeID) {
                return this.itsAttributeID > aCompareTo.itsAttributeID ? 1 : -1;
            }
            return 0;
        }
    }

    private static class ValueComparator
    implements Comparator {
        public static final ValueComparator INSTANCE = new ValueComparator();

        private ValueComparator() {
        }

        public int compare(Object theObject1, Object theObject2) {
            if (theObject1 instanceof Comparable && theObject1.getClass() == theObject2.getClass()) {
                return ((Comparable)theObject1).compareTo(theObject2);
            }
            return theObject1.toString().compareTo(theObject2.toString());
        }

        public boolean equals(Object theCompareTo) {
            return theCompareTo instanceof ValueComparator;
        }

        public ValueComparator getInstance() {
            return INSTANCE;
        }
    }

    private static class EmptyValue
    implements Comparable {
        private static final String EMPTY_STRING = "";
        public static final EmptyValue INSTANCE = new EmptyValue();

        EmptyValue() {
        }

        public int compareTo(Object theCompareTo) {
            if (theCompareTo instanceof EmptyValue) {
                return 0;
            }
            return EMPTY_STRING.compareTo(theCompareTo.toString());
        }

        public boolean equals(Object theCompareTo) {
            if (theCompareTo instanceof EmptyValue) {
                return true;
            }
            return theCompareTo.toString().length() == 0;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return EMPTY_STRING;
        }

        public EmptyValue getInstance() {
            return INSTANCE;
        }
    }
}

