/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XSDBaseNumericType
extends XSDDatatype {
    public XSDBaseNumericType(String string) {
        super(string);
    }

    public XSDBaseNumericType(String string, Class clazz) {
        super(string, clazz);
    }

    public boolean isValidLiteral(LiteralLabel literalLabel) {
        RDFDatatype rDFDatatype = literalLabel.getDatatype();
        if (this.equals(rDFDatatype)) {
            return true;
        }
        if (rDFDatatype instanceof XSDBaseNumericType) {
            String string = literalLabel.getLexicalForm();
            if (JenaParameters.enableWhitespaceCheckingOfTypedLiterals) {
                if (string.trim().equals(string)) {
                    return this.isValid(literalLabel.getLexicalForm());
                }
                return false;
            }
            return this.isValid(literalLabel.getLexicalForm());
        }
        return false;
    }

    public boolean isValidValue(Object object) {
        if (object instanceof Number) {
            return this.isValid(object.toString());
        }
        return false;
    }

    public Object parse(String string) throws DatatypeFormatException {
        this.checkWhitespace(string);
        return super.parse(string);
    }

    protected void checkWhitespace(String string) {
        if (JenaParameters.enableWhitespaceCheckingOfTypedLiterals && !string.trim().equals(string)) {
            throw new DatatypeFormatException(string, this, "whitespace violation");
        }
    }

    public boolean isEqual(LiteralLabel literalLabel, LiteralLabel literalLabel2) {
        Object object = literalLabel.getValue();
        Object object2 = literalLabel2.getValue();
        if (!(object instanceof Number) || !(object2 instanceof Number)) {
            return false;
        }
        if (object instanceof Float || object instanceof Double) {
            return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
        }
        if (object instanceof BigInteger || object instanceof BigDecimal) {
            return object.equals(object2);
        }
        return ((Number)object).longValue() == ((Number)object2).longValue();
    }
}

