/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetReifIterator
extends ResultSetIterator {
    protected IDBID m_graphID;
    protected IPSet m_pset;
    protected Node m_subjNode;
    protected Node m_predNode;
    protected Node m_objNode;
    protected Node m_stmtURI;
    protected boolean m_hasType;
    protected boolean m_getTriples;
    protected int m_fragCount;
    protected int m_fragRem;
    protected int m_nextFrag;
    protected static Log logger = LogFactory.getLog((Class)(class$com$hp$hpl$jena$db$impl$ResultSetReifIterator == null ? (class$com$hp$hpl$jena$db$impl$ResultSetReifIterator = ResultSetReifIterator.class$("com.hp.hpl.jena.db.impl.ResultSetReifIterator")) : class$com$hp$hpl$jena$db$impl$ResultSetReifIterator));
    static /* synthetic */ Class class$com$hp$hpl$jena$db$impl$ResultSetReifIterator;

    public ResultSetReifIterator(IPSet iPSet, boolean bl, IDBID iDBID) {
        this.m_pset = iPSet;
        this.setGraphID(iDBID);
        this.m_getTriples = bl;
    }

    public void setGraphID(IDBID iDBID) {
        this.m_graphID = iDBID;
    }

    public void reset(ResultSet resultSet, PreparedStatement preparedStatement, SQLCache sQLCache, String string) {
        super.reset(resultSet, preparedStatement, sQLCache, string);
    }

    protected void extractRow() throws SQLException {
        boolean bl = true;
        ResultSet resultSet = this.m_resultSet;
        String string = resultSet.getString(1);
        String string2 = resultSet.getString(2);
        String string3 = resultSet.getString(3);
        this.m_stmtURI = this.m_pset.driver().RDBStringToNode(resultSet.getString(4));
        this.m_hasType = resultSet.getString(5).equals("T");
        int n = this.m_fragRem = this.m_hasType ? 1 : 0;
        if (string == null) {
            this.m_subjNode = Node.NULL;
        } else {
            this.m_subjNode = this.m_pset.driver().RDBStringToNode(string);
            ++this.m_fragRem;
        }
        if (string2 == null) {
            this.m_predNode = Node.NULL;
        } else {
            this.m_predNode = this.m_pset.driver().RDBStringToNode(string2);
            ++this.m_fragRem;
        }
        if (string3 == null) {
            this.m_objNode = Node.NULL;
        } else {
            this.m_objNode = this.m_pset.driver().RDBStringToNode(string3);
            ++this.m_fragRem;
        }
        this.m_nextFrag = 0;
        this.m_fragCount = this.m_fragRem;
    }

    protected Object getRow() {
        Triple triple = null;
        if (this.m_getTriples) {
            if (this.m_nextFrag == 0) {
                if (!this.m_subjNode.equals(Node.NULL)) {
                    triple = new Triple(this.m_stmtURI, RDF.Nodes.subject, this.m_subjNode);
                    --this.m_fragRem;
                } else {
                    ++this.m_nextFrag;
                }
            }
            if (this.m_nextFrag == 1) {
                if (!this.m_predNode.equals(Node.NULL)) {
                    triple = new Triple(this.m_stmtURI, RDF.Nodes.predicate, this.m_predNode);
                    --this.m_fragRem;
                } else {
                    ++this.m_nextFrag;
                }
            }
            if (this.m_nextFrag == 2) {
                if (!this.m_objNode.equals(Node.NULL)) {
                    triple = new Triple(this.m_stmtURI, RDF.Nodes.object, this.m_objNode);
                    --this.m_fragRem;
                } else {
                    ++this.m_nextFrag;
                }
            }
            if (this.m_nextFrag >= 3) {
                if (this.m_hasType) {
                    triple = new Triple(this.m_stmtURI, RDF.Nodes.type, RDF.Nodes.Statement);
                    --this.m_fragRem;
                } else {
                    throw new JenaException("Reified triple not found");
                }
            }
            ++this.m_nextFrag;
            if (this.m_fragRem > 0) {
                this.m_prefetched = true;
            }
        } else {
            triple = new Triple(this.m_subjNode, this.m_predNode, this.m_objNode);
        }
        return triple;
    }

    protected boolean hasSubj() {
        return this.m_subjNode != Node.NULL;
    }

    protected boolean hasPred() {
        return this.m_predNode != Node.NULL;
    }

    protected boolean hasObj() {
        return this.m_objNode != Node.NULL;
    }

    protected boolean hasType() {
        return this.m_hasType;
    }

    protected int getFragCount() {
        return this.m_fragCount;
    }

    protected Node getStmtURI() {
        return this.m_stmtURI;
    }

    protected boolean getHasType() {
        return this.m_hasType;
    }

    protected void deleteRow() {
        try {
            this.m_resultSet.deleteRow();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", sQLException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

