/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.shared.JenaException;

public class VarDesc {
    Node_Variable var;
    boolean isArgVar;
    boolean isBoundToCol;
    int resIx;
    int mapIx;
    int alias;
    char column;

    public VarDesc(Node node, int n, int n2) {
        this.var = (Node_Variable)node;
        this.isArgVar = true;
        this.mapIx = n;
        this.resIx = n2;
        this.isBoundToCol = false;
    }

    public VarDesc(Node node, int n) {
        this.var = (Node_Variable)node;
        this.isArgVar = false;
        this.mapIx = -1;
        this.resIx = n;
        this.isBoundToCol = false;
    }

    public void bindToVarMap(Mapping mapping) {
        if (this.isArgVar) {
            throw new JenaException("Variable bound twice to argument");
        }
        this.mapIx = mapping.newIndex(this.var);
    }

    public void bindToCol(int n, char c) {
        if (this.isBoundToCol) {
            throw new JenaException("Variable bound twice to column");
        }
        this.isBoundToCol = true;
        this.alias = n;
        this.column = c;
    }

    public boolean isBoundToCol() {
        return this.isBoundToCol;
    }

    public boolean isArgVar() {
        return this.isArgVar;
    }
}

