/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestCompareToMem
extends TestCase {
    static Log logger = LogFactory.getLog((Class)(class$com$hp$hpl$jena$db$test$TestCompareToMem == null ? (class$com$hp$hpl$jena$db$test$TestCompareToMem = TestCompareToMem.class$("com.hp.hpl.jena.db.test.TestCompareToMem")) : class$com$hp$hpl$jena$db$test$TestCompareToMem));
    Model modelrdf = null;
    Model modelmem = null;
    IDBConnection conn = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$db$test$TestCompareToMem;

    public TestCompareToMem(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$db$test$TestCompareToMem == null ? (class$com$hp$hpl$jena$db$test$TestCompareToMem = TestCompareToMem.class$("com.hp.hpl.jena.db.test.TestCompareToMem")) : class$com$hp$hpl$jena$db$test$TestCompareToMem);
    }

    protected void setUp() throws Exception {
        this.conn = TestConnection.makeAndCleanTestConnection();
        this.modelrdf = ModelRDB.createModel(this.conn);
        this.modelmem = ModelFactory.createDefaultModel();
    }

    protected void tearDown() throws Exception {
        this.modelrdf.close();
        this.modelrdf = null;
        this.conn.cleanDB();
        this.conn.close();
        this.conn = null;
    }

    private void addRemove(Statement statement) {
        this.modelrdf.add(statement);
        this.modelmem.add(statement);
        TestCompareToMem.assertTrue((this.modelmem.size() == 1L ? 1 : 0) != 0);
        TestCompareToMem.assertTrue((this.modelrdf.size() == 1L ? 1 : 0) != 0);
        this.compareModels();
        this.modelrdf.remove(statement);
        this.modelmem.remove(statement);
        TestCompareToMem.assertTrue((this.modelmem.size() == 0L ? 1 : 0) != 0);
        TestCompareToMem.assertTrue((this.modelrdf.size() == 0L ? 1 : 0) != 0);
        this.compareModels();
    }

    private void compareModels() {
        Statement statement;
        StmtIterator stmtIterator = this.modelmem.listStatements();
        while (stmtIterator.hasNext()) {
            statement = (Statement)stmtIterator.next();
            if (!this.modelrdf.contains(statement)) {
                logger.error((Object)("Statment:" + statement + " is in mem but not rdf"));
                this.logModel(this.modelmem, "Mem");
                this.logModel(this.modelrdf, "RDF");
            }
            TestCompareToMem.assertTrue((boolean)this.modelrdf.contains(statement));
        }
        stmtIterator = this.modelrdf.listStatements();
        while (stmtIterator.hasNext()) {
            statement = (Statement)stmtIterator.next();
            if (!this.modelmem.contains(statement)) {
                logger.error((Object)("Statment:" + statement + " is in rdf but not memory"));
                this.logModel(this.modelmem, "Mem");
                this.logModel(this.modelrdf, "RDF");
            }
            TestCompareToMem.assertTrue((boolean)this.modelmem.contains(statement));
        }
    }

    private void logModel(Model model, String string) {
        logger.debug((Object)"Model");
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            Statement statement = (Statement)stmtIterator.next();
            RDFNode rDFNode = statement.getObject();
            if (rDFNode instanceof Literal) {
                logger.debug((Object)(string + ": " + statement.getSubject() + statement.getPredicate() + ((Literal)rDFNode).getValue() + " " + ((Literal)rDFNode).getDatatype() + " " + ((Literal)rDFNode).getLanguage()));
                continue;
            }
            logger.debug((Object)(string + ": " + stmtIterator.next()));
        }
    }

    public void testAddRemoveURI() {
        Resource resource = this.modelrdf.createResource("test#subject");
        Property property = this.modelrdf.createProperty("test#predicate");
        Resource resource2 = this.modelrdf.createResource("test#object");
        this.addRemove(this.modelrdf.createStatement(resource, property, resource2));
    }

    public void testAddRemoveLiteral() {
        Resource resource = this.modelrdf.createResource("test#subject");
        Property property = this.modelrdf.createProperty("test#predicate");
        Literal literal = this.modelrdf.createLiteral("testLiteral");
        this.addRemove(this.modelrdf.createStatement(resource, property, literal));
    }

    public void testAddRemoveHugeLiteral() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.modelrdf.createResource("test#subject");
        Property property = this.modelrdf.createProperty("test#predicate");
        Literal literal = this.modelrdf.createLiteral(stringBuffer.toString());
        this.addRemove(this.modelrdf.createStatement(resource, property, literal));
    }

    public void testAddRemoveDatatype() {
        Resource resource = this.modelrdf.createResource("test#subject");
        Property property = this.modelrdf.createProperty("test#predicate");
        Literal literal = this.modelrdf.createTypedLiteral("stringType");
        this.addRemove(this.modelrdf.createStatement(resource, property, literal));
    }

    public void testAddRemoveHugeDatatype() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.modelrdf.createResource("test#subject");
        Property property = this.modelrdf.createProperty("test#predicate");
        Literal literal = this.modelrdf.createTypedLiteral(stringBuffer.toString());
        this.addRemove(this.modelrdf.createStatement(resource, property, literal));
    }

    public void testAddRemoveHugeLiteral2() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.modelmem.createResource("test#subject");
        Property property = this.modelmem.createProperty("test#predicate");
        Literal literal = this.modelmem.createLiteral(stringBuffer.toString());
        Literal literal2 = this.modelmem.createLiteral(stringBuffer.toString() + ".");
        Statement statement = this.modelmem.createStatement(resource, property, literal);
        Statement statement2 = this.modelmem.createStatement(resource, property, literal2);
        this.modelrdf.add(statement);
        this.modelmem.add(statement);
        this.compareModels();
        this.modelrdf.add(statement2);
        this.modelmem.add(statement2);
        this.compareModels();
        this.modelrdf.remove(statement2);
        this.modelmem.remove(statement2);
        this.compareModels();
        this.modelrdf.remove(statement);
        this.modelmem.remove(statement);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

