/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.GraphAdd;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;

public interface Graph
extends GraphAdd {
    public static final Graph emptyGraph = new GraphBase(){

        public ExtendedIterator find(TripleMatch tripleMatch) {
            return new NiceIterator();
        }
    };

    public boolean dependsOn(Graph var1);

    public QueryHandler queryHandler();

    public TransactionHandler getTransactionHandler();

    public BulkUpdateHandler getBulkUpdateHandler();

    public Capabilities getCapabilities();

    public GraphEventManager getEventManager();

    public Reifier getReifier();

    public PrefixMapping getPrefixMapping();

    public void delete(Triple var1) throws DeleteDeniedException;

    public ExtendedIterator find(TripleMatch var1);

    public ExtendedIterator find(Node var1, Node var2, Node var3);

    public boolean isIsomorphicWith(Graph var1);

    public boolean contains(Node var1, Node var2, Node var3);

    public boolean contains(Triple var1);

    public void close();

    public boolean isEmpty();

    public int size();
}

