/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.vocabulary.JMS;
import com.hp.hpl.jena.vocabulary.RDF;

public abstract class BaseGraphMaker
implements GraphMaker {
    private int counter = 0;
    protected ReificationStyle style;
    private Graph defaultGraph;

    public BaseGraphMaker(ReificationStyle reificationStyle) {
        this.style = reificationStyle;
    }

    public ReificationStyle getReificationStyle() {
        return this.style;
    }

    public Graph getGraph() {
        if (this.defaultGraph == null) {
            this.defaultGraph = this.createGraph();
        }
        return this.defaultGraph;
    }

    public Graph createGraph() {
        return this.createGraph("anon_" + this.counter++ + "", false);
    }

    public Graph createGraph(String string) {
        return this.createGraph(string, false);
    }

    public Graph openGraph(String string) {
        return this.openGraph(string, false);
    }

    public Graph getDescription() {
        return this.getDescription(Node.createAnon());
    }

    public Graph getDescription(Node node) {
        GraphMem graphMem = new GraphMem();
        this.addDescription(graphMem, node);
        return graphMem;
    }

    public Graph addDescription(Graph graph, Node node) {
        Node node2 = JMS.styleAsJMS(this.style);
        graph.add(Triple.create(node, JMS.reificationMode.asNode(), node2));
        graph.add(Triple.create(node, RDF.Nodes.type, this.getMakerClass()));
        this.augmentDescription(graph, node);
        return graph;
    }

    protected abstract void augmentDescription(Graph var1, Node var2);

    public abstract Node getMakerClass();
}

