/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.GraphAdd;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.FragmentMap;
import com.hp.hpl.jena.graph.impl.Fragments;
import com.hp.hpl.jena.graph.impl.GraphAddList;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class FragmentTripleIterator
extends NiceIterator {
    private final GraphAddList pending;
    private final Iterator it;

    public FragmentTripleIterator(Triple triple, Iterator iterator) {
        this.it = iterator;
        this.pending = new GraphAddList(triple);
    }

    static ExtendedIterator toIterator(Triple triple, Node node, Object object) {
        GraphAddList graphAddList = new GraphAddList(triple);
        FragmentTripleIterator.fill(graphAddList, node, object);
        return WrappedIterator.create(graphAddList.iterator());
    }

    public boolean hasNext() {
        this.refill();
        return this.pending.size() > 0;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.pending.remove(this.pending.size() - 1);
    }

    private static void fill(GraphAdd graphAdd, Node node, Object object) {
        if (object instanceof Triple) {
            FragmentMap.graphAddQuad(graphAdd, node, (Triple)object);
        } else {
            ((Fragments)object).includeInto(graphAdd);
        }
    }

    private void refill() {
        while (this.pending.size() == 0 && this.it.hasNext()) {
            Map.Entry entry = (Map.Entry)this.it.next();
            FragmentTripleIterator.fill(this.pending, (Node)entry.getKey(), entry.getValue());
        }
    }
}

