/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.GraphAdd;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Fragments {
    private final Set[] slots = new Set[]{new HashSet(), new HashSet(), new HashSet(), new HashSet()};
    private Node anchor;
    private static final int TYPES = 0;
    private static final int SUBJECTS = 1;
    private static final int PREDICATES = 2;
    private static final int OBJECTS = 3;
    private static final HashMap selectors = Fragments.makeSelectors();

    public Fragments(Node node) {
        this.anchor = node;
    }

    public Fragments(Node node, Triple triple) {
        this(node);
        this.addTriple(triple);
    }

    public boolean isComplete() {
        return this.slots[0].size() == 1 && this.slots[1].size() == 1 && this.slots[2].size() == 1 && this.slots[3].size() == 1;
    }

    public boolean isEmpty() {
        return this.slots[0].isEmpty() && this.slots[1].isEmpty() && this.slots[2].isEmpty() && this.slots[3].isEmpty();
    }

    public void remove(int n, Node node) {
        this.slots[n].remove(node);
    }

    public void add(int n, Node node) {
        this.slots[n].add(node);
    }

    public void includeInto(GraphAdd graphAdd) {
        this.includeInto(graphAdd, RDF.Nodes.subject, 1);
        this.includeInto(graphAdd, RDF.Nodes.predicate, 2);
        this.includeInto(graphAdd, RDF.Nodes.object, 3);
        this.includeInto(graphAdd, RDF.Nodes.type, 0);
    }

    private void includeInto(GraphAdd graphAdd, Node node, int n) {
        Iterator iterator = this.slots[n].iterator();
        while (iterator.hasNext()) {
            graphAdd.add(new Triple(this.anchor, node, (Node)iterator.next()));
        }
    }

    public Fragments addTriple(Triple triple) {
        this.slots[1].add(triple.getSubject());
        this.slots[2].add(triple.getPredicate());
        this.slots[3].add(triple.getObject());
        this.slots[0].add(RDF.Nodes.Statement);
        return this;
    }

    Triple asTriple() {
        return new Triple(this.only(this.slots[1]), this.only(this.slots[2]), this.only(this.slots[3]));
    }

    private Node only(Set set) {
        return (Node)set.iterator().next();
    }

    public String toString() {
        return this.anchor + " s:" + this.slots[1] + " p:" + this.slots[2] + " o:" + this.slots[3] + " t:" + this.slots[0];
    }

    public static int getFragmentSelector(Triple triple) {
        Node node = triple.getPredicate();
        Integer n = (Integer)selectors.get(node);
        if (n == null || node.equals(RDF.Nodes.type) && !triple.getObject().equals(RDF.Nodes.Statement)) {
            return -1;
        }
        return n;
    }

    private static HashMap makeSelectors() {
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        hashMap.put(RDF.Nodes.subject, new Integer(1));
        hashMap.put(RDF.Nodes.predicate, new Integer(2));
        hashMap.put(RDF.Nodes.object, new Integer(3));
        hashMap.put(RDF.Nodes.type, new Integer(0));
        return hashMap;
    }
}

